/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.PacketOrigin;
import org.jitsi.nlj.format.AudioRedPayloadType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RedAudioRtpPacket;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.Config;
import org.jitsi.nlj.transform.node.MultipleOutputTransformerNode;
import org.jitsi.nlj.transform.node.RedDistance;
import org.jitsi.nlj.transform.node.RedPolicy;
import org.jitsi.nlj.transform.node.Stats;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.nlj.util.RtpPacketCache;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.ByteArrayBufferKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.AudioLevelHeaderExtension;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0002&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001eH\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\u0018R\u00020\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jitsi/nlj/transform/node/AudioRedHandler;", "Lorg/jitsi/nlj/transform/node/MultipleOutputTransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "stats", "Lorg/jitsi/nlj/transform/node/Stats;", "audioLevelExtId", "", "getAudioLevelExtId", "()Ljava/lang/Integer;", "setAudioLevelExtId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "redPayloadType", "getRedPayloadType", "setRedPayloadType", "ssrcRedHandlers", "", "", "Lorg/jitsi/nlj/transform/node/AudioRedHandler$SsrcRedHandler;", "transform", "", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "trace", "", "f", "Lkotlin/Function0;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "stop", "SsrcRedHandler", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nAudioRedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioRedHandler.kt\norg/jitsi/nlj/transform/node/AudioRedHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n1863#2,2:343\n1#3:345\n*S KotlinDebug\n*F\n+ 1 AudioRedHandler.kt\norg/jitsi/nlj/transform/node/AudioRedHandler\n*L\n102#1:343,2\n*E\n"})
public final class AudioRedHandler
extends MultipleOutputTransformerNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Stats stats;
    @Nullable
    private Integer audioLevelExtId;
    @Nullable
    private Integer redPayloadType;
    @NotNull
    private final Map<Long, SsrcRedHandler> ssrcRedHandlers;
    @NotNull
    private static final Config config = new Config();

    public AudioRedHandler(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("RedHandler");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.stats = new Stats(0, 0, 0, 0, 0, 0, 0, 127, null);
        this.ssrcRedHandlers = new HashMap();
        streamInformationStore.onRtpPayloadTypesChanged(arg_0 -> AudioRedHandler._init_$lambda$1(this, arg_0));
        streamInformationStore.onRtpExtensionMapping(RtpExtensionType.SSRC_AUDIO_LEVEL, arg_0 -> AudioRedHandler._init_$lambda$2(this, arg_0));
    }

    @Nullable
    public final Integer getAudioLevelExtId() {
        return this.audioLevelExtId;
    }

    public final void setAudioLevelExtId(@Nullable Integer n) {
        this.audioLevelExtId = n;
    }

    @Nullable
    public final Integer getRedPayloadType() {
        return this.redPayloadType;
    }

    public final void setRedPayloadType(@Nullable Integer n) {
        this.redPayloadType = n;
    }

    @Override
    @NotNull
    protected List<PacketInfo> transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        AudioRtpPacket audioRtpPacket = packet instanceof AudioRtpPacket ? (AudioRtpPacket)packet : null;
        if (audioRtpPacket == null) {
            return CollectionsKt.listOf(packetInfo);
        }
        AudioRtpPacket audioPacket = audioRtpPacket;
        SsrcRedHandler ssrcRedHandler = this.ssrcRedHandlers.computeIfAbsent(audioPacket.getSsrc(), arg_0 -> AudioRedHandler.transform$lambda$4(arg_0 -> AudioRedHandler.transform$lambda$3(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(ssrcRedHandler, "computeIfAbsent(...)");
        SsrcRedHandler ssrcHandler = ssrcRedHandler;
        return audioPacket instanceof RedAudioRtpPacket ? ssrcHandler.transformRed(packetInfo) : CollectionsKt.listOf(ssrcHandler.transformAudio(packetInfo));
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u245 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        Object object = this.redPayloadType;
        if (object == null || (object = ((Integer)object).toString()) == null) {
            object = "null";
        }
        $this$getNodeStats_u24lambda_u245.addString("red_payload_type", (String)object);
        Object object2 = this.audioLevelExtId;
        if (object2 == null || (object2 = ((Integer)object2).toString()) == null) {
            object2 = "null";
        }
        $this$getNodeStats_u24lambda_u245.addString("audio_level_ext_id", (String)object2);
        $this$getNodeStats_u24lambda_u245.addString("policy", config.getPolicy().toString());
        $this$getNodeStats_u24lambda_u245.addString("distance", config.getDistance().toString());
        $this$getNodeStats_u24lambda_u245.addBoolean("vad_only", config.getVadOnly());
        $this$getNodeStats_u24lambda_u245.addNumber("red_packets_decapsulated", this.stats.getRedPacketsDecapsulated());
        $this$getNodeStats_u24lambda_u245.addNumber("red_packets_forwarded", this.stats.getRedPacketsForwarded());
        $this$getNodeStats_u24lambda_u245.addNumber("audio_packets_encapsulated", this.stats.getAudioPacketsEncapsulated());
        $this$getNodeStats_u24lambda_u245.addNumber("audio_packets_forwarded", this.stats.getAudioPacketsForwarded());
        $this$getNodeStats_u24lambda_u245.addNumber("lost_packets_recovered", this.stats.getLostPacketsRecovered());
        $this$getNodeStats_u24lambda_u245.addNumber("redundancy_packets_added", this.stats.getRedundancyPacketsAdded());
        $this$getNodeStats_u24lambda_u245.addNumber("invalid_red_packets_dropped", this.stats.getInvalidRedPacketsDropped());
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    public OrderedJsonObject statsJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$statsJson_u24lambda_u246 = orderedJsonObject = super.statsJson();
        boolean bl = false;
        ((Map)$this$statsJson_u24lambda_u246).put("red_packets_decapsulated", this.stats.getRedPacketsDecapsulated());
        ((Map)$this$statsJson_u24lambda_u246).put("red_packets_forwarded", this.stats.getRedPacketsForwarded());
        ((Map)$this$statsJson_u24lambda_u246).put("audio_packets_encapsulated", this.stats.getAudioPacketsEncapsulated());
        ((Map)$this$statsJson_u24lambda_u246).put("audio_packets_forwarded", this.stats.getAudioPacketsForwarded());
        ((Map)$this$statsJson_u24lambda_u246).put("lost_packets_recovered", this.stats.getLostPacketsRecovered());
        ((Map)$this$statsJson_u24lambda_u246).put("redundancy_packets_added", this.stats.getRedundancyPacketsAdded());
        ((Map)$this$statsJson_u24lambda_u246).put("invalid_red_packets_dropped", this.stats.getInvalidRedPacketsDropped());
        return orderedJsonObject;
    }

    @Override
    public void stop() {
        Unit unit;
        super.stop();
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        Iterable $this$forEach$iv = this.ssrcRedHandlers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SsrcRedHandler it2 = (SsrcRedHandler)element$iv;
            boolean bl2 = false;
            it2.stop();
        }
        this.ssrcRedHandlers.clear();
    }

    private static final Unit _init_$lambda$1(AudioRedHandler this$0, Map payloadTypes) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(payloadTypes, "payloadTypes");
            Iterable iterable = payloadTypes.values();
            AudioRedHandler audioRedHandler = this$0;
            Iterable iterable2 = iterable;
            for (Object t2 : iterable2) {
                PayloadType it = (PayloadType)t2;
                boolean bl = false;
                if (!(it instanceof AudioRedPayloadType)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        PayloadType payloadType = v0;
        audioRedHandler.redPayloadType = payloadType != null ? Integer.valueOf(payloadType.getPt()) : null;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(AudioRedHandler this$0, Integer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.audioLevelExtId = it;
        return Unit.INSTANCE;
    }

    private static final SsrcRedHandler transform$lambda$3(AudioRedHandler this$0, Long it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.new SsrcRedHandler();
    }

    private static final SsrcRedHandler transform$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (SsrcRedHandler)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/transform/node/AudioRedHandler$Companion;", "", "<init>", "()V", "config", "Lorg/jitsi/nlj/transform/node/Config;", "getConfig", "()Lorg/jitsi/nlj/transform/node/Config;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Config getConfig() {
            return config;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\fH\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/nlj/transform/node/AudioRedHandler$SsrcRedHandler;", "", "<init>", "(Lorg/jitsi/nlj/transform/node/AudioRedHandler;)V", "sentAudioCache", "Lorg/jitsi/nlj/util/RtpPacketCache;", "getSentAudioCache", "()Lorg/jitsi/nlj/util/RtpPacketCache;", "transformAudio", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "getPacketToProtect", "Lorg/jitsi/rtp/rtp/RtpPacket;", "seq", "", "primaryTimestamp", "", "vadOnly", "", "hasVad", "stop", "", "transformRed", "", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nAudioRedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioRedHandler.kt\norg/jitsi/nlj/transform/node/AudioRedHandler$SsrcRedHandler\n+ 2 RtpUtils.kt\norg/jitsi/rtp/util/RtpUtils$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Packet.kt\norg/jitsi/rtp/Packet\n*L\n1#1,342:1\n112#2:343\n1#3:344\n1863#4,2:345\n29#5:347\n*S KotlinDebug\n*F\n+ 1 AudioRedHandler.kt\norg/jitsi/nlj/transform/node/AudioRedHandler$SsrcRedHandler\n*L\n203#1:343\n247#1:345,2\n271#1:347\n*E\n"})
    private final class SsrcRedHandler {
        @NotNull
        private final RtpPacketCache sentAudioCache = new RtpPacketCache(20, true);

        @NotNull
        public final RtpPacketCache getSentAudioCache() {
            return this.sentAudioCache;
        }

        @NotNull
        public final PacketInfo transformAudio(@NotNull PacketInfo packetInfo) {
            boolean bl;
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            switch (WhenMappings.$EnumSwitchMapping$0[Companion.getConfig().getPolicy().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean encapsulate = bl;
            Integer redPayloadType = AudioRedHandler.this.getRedPayloadType();
            if (redPayloadType == null || !encapsulate) {
                AudioRedHandler.this.stats.audioPacketForwarded();
                return packetInfo;
            }
            AudioRtpPacket audioRtpPacket = (AudioRtpPacket)packetInfo.packetAs();
            this.sentAudioCache.insert(audioRtpPacket);
            List redundancy = new ArrayList();
            int seq = audioRtpPacket.getSequenceNumber();
            switch (WhenMappings.$EnumSwitchMapping$1[Companion.getConfig().getDistance().ordinal()]) {
                case 1: {
                    RtpPacket rtpPacket = this.getPacketToProtect(RtpUtils.Companion.applySequenceNumberDelta(seq, -1), audioRtpPacket.getTimestamp(), Companion.getConfig().getVadOnly());
                    if (rtpPacket == null) break;
                    RtpPacket rtpPacket2 = rtpPacket;
                    AudioRedHandler audioRedHandler = AudioRedHandler.this;
                    RtpPacket secondary = rtpPacket2;
                    boolean bl2 = false;
                    redundancy.add(secondary);
                    audioRedHandler.stats.redundancyPacketAdded();
                    break;
                }
                case 2: {
                    RtpPacket rtpPacket = this.getPacketToProtect(RtpUtils.Companion.applySequenceNumberDelta(seq, -1), audioRtpPacket.getTimestamp(), false);
                    if (rtpPacket == null) break;
                    RtpPacket rtpPacket3 = rtpPacket;
                    AudioRedHandler audioRedHandler = AudioRedHandler.this;
                    RtpPacket secondary = rtpPacket3;
                    boolean bl3 = false;
                    RtpPacket tertiary = this.getPacketToProtect(RtpUtils.Companion.applySequenceNumberDelta(seq, -2), audioRtpPacket.getTimestamp(), Companion.getConfig().getVadOnly());
                    if (tertiary != null) {
                        redundancy.add(tertiary);
                        audioRedHandler.stats.redundancyPacketAdded();
                        redundancy.add(secondary);
                        audioRedHandler.stats.redundancyPacketAdded();
                        break;
                    }
                    if (Companion.getConfig().getVadOnly() && !this.hasVad(secondary)) break;
                    redundancy.add(secondary);
                    audioRedHandler.stats.redundancyPacketAdded();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            RedAudioRtpPacket redPacket = RedAudioRtpPacket.Companion.getBuilder().build(redPayloadType, audioRtpPacket, redundancy);
            packetInfo.setPacket(redPacket);
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(audioRtpPacket.buffer, "buffer");
            function1.invoke(audioRtpPacket.buffer);
            AudioRedHandler.this.stats.audioPacketEncapsulated();
            return packetInfo;
        }

        private final RtpPacket getPacketToProtect(int seq, long primaryTimestamp, boolean vadOnly) {
            Object object = this.sentAudioCache.peek(seq);
            if (object != null && (object = (RtpPacket)((ArrayCache.Container)object).getItem()) != null) {
                Object it = object;
                boolean bl = false;
                if (!vadOnly || this.hasVad((RtpPacket)it)) {
                    RtpUtils.Companion companion = RtpUtils.Companion;
                    long b$iv = ((RtpPacket)it).getTimestamp();
                    boolean $i$f$getTimestampDiffAsInt = false;
                    if ((int)(primaryTimestamp - b$iv) <= 16383) {
                        return it;
                    }
                }
            }
            return null;
        }

        private final boolean hasVad(RtpPacket $this$hasVad) {
            boolean bl;
            Integer n = AudioRedHandler.this.getAudioLevelExtId();
            if (n != null) {
                int extId = ((Number)n).intValue();
                boolean bl2 = false;
                RtpPacket.HeaderExtension headerExtension = $this$hasVad.getHeaderExtension(extId);
                if (headerExtension != null) {
                    RtpPacket.HeaderExtension it = headerExtension;
                    boolean bl3 = false;
                    bl = AudioLevelHeaderExtension.Companion.getVad(it);
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public final void stop() {
            this.sentAudioCache.flush();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PacketInfo> transformRed(@NotNull PacketInfo packetInfo) {
            List<PacketInfo> list;
            boolean bl;
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            if (AudioRedHandler.this.getRedPayloadType() == null) {
                bl = true;
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[Companion.getConfig().getPolicy().ordinal()]) {
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean strip = bl;
            if (strip) {
                List<PacketInfo> list2;
                block15: {
                    void p2;
                    void p1;
                    void p0;
                    Object it;
                    AudioRedHandler audioRedHandler = AudioRedHandler.this;
                    List<PacketInfo> $this$transformRed_u24lambda_u246 = list2 = CollectionsKt.createListBuilder();
                    boolean bl2 = false;
                    RedAudioRtpPacket redPacket = (RedAudioRtpPacket)packetInfo.packetAs();
                    int seq = redPacket.getSequenceNumber();
                    int prev = RtpUtils.Companion.applySequenceNumberDelta(seq, -1);
                    int prev2 = RtpUtils.Companion.applySequenceNumberDelta(seq, -2);
                    boolean prevMissing = !this.sentAudioCache.contains(prev);
                    boolean prev2Missing = !this.sentAudioCache.contains(prev2);
                    try {
                        if (prevMissing || prev2Missing) {
                            Iterable $this$forEach$iv = redPacket.removeRedAndGetRedundancyPackets();
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (AudioRtpPacket)element$iv;
                                boolean bl3 = false;
                                if (((RtpPacket)it).getSequenceNumber() == prev && prevMissing || ((RtpPacket)it).getSequenceNumber() == prev2 && prev2Missing) {
                                    PacketInfo packetInfo2 = new PacketInfo((Packet)it, 0, null, 6, null);
                                    packetInfo2.setPacketOrigin(PacketOrigin.Synthesized);
                                    $this$transformRed_u24lambda_u246.add(packetInfo2);
                                    audioRedHandler.stats.lostPacketRecovered();
                                }
                                this.sentAudioCache.insert((RtpPacket)it);
                            }
                        } else {
                            redPacket.removeRed();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        audioRedHandler.logger.warn("Dropping invalid RED packet from ep=" + packetInfo.getEndpointId() + " (" + e.getMessage() + "): " + redPacket + ". Contents (50B): " + ByteArrayBufferKt.toHex(redPacket, 50));
                        audioRedHandler.stats.invalidRedPacketDropped();
                        break block15;
                    }
                    audioRedHandler.stats.redPacketDecapsulated();
                    Packet this_$iv = redPacket;
                    boolean $i$f$toOtherType = false;
                    Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                    int n = this_$iv.length;
                    int element$iv = this_$iv.offset;
                    it = this_$iv.buffer;
                    PacketInfo packetInfo3 = packetInfo;
                    boolean bl4 = false;
                    packetInfo3.setPacket(new AudioRtpPacket((byte[])p0, (int)p1, (int)p2));
                    if (!this.sentAudioCache.contains(seq)) {
                        this.sentAudioCache.insert((RtpPacket)packetInfo.packetAs());
                        $this$transformRed_u24lambda_u246.add(packetInfo);
                    }
                }
                list = CollectionsKt.build(list2);
            } else {
                AudioRedHandler.this.stats.redPacketForwarded();
                list = CollectionsKt.listOf(packetInfo);
            }
            return list;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[RedPolicy.values().length];
                try {
                    nArray[RedPolicy.NOOP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RedPolicy.STRIP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RedPolicy.PROTECT_ALL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[RedDistance.values().length];
                try {
                    nArray[RedDistance.ONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RedDistance.TWO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

