/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_ibb;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.transports.JingleTransportInitiationCallback;
import org.jivesoftware.smackx.jingle.transports.JingleTransportManager;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.JingleIBBTransportManager;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.element.JingleIBBTransport;

public class JingleIBBTransportSession
extends JingleTransportSession<JingleIBBTransport> {
    private static final Logger LOGGER = Logger.getLogger(JingleIBBTransportSession.class.getName());
    private final JingleIBBTransportManager transportManager;

    public JingleIBBTransportSession(JingleSession session) {
        super(session);
        this.transportManager = JingleIBBTransportManager.getInstanceFor(session.getConnection());
    }

    @Override
    public JingleIBBTransport createTransport() {
        if (this.theirProposal == null) {
            return new JingleIBBTransport();
        }
        return new JingleIBBTransport(((JingleIBBTransport)this.theirProposal).getBlockSize(), ((JingleIBBTransport)this.theirProposal).getSessionId());
    }

    @Override
    public void setTheirProposal(JingleContentTransport transport) {
        this.theirProposal = (JingleIBBTransport)transport;
    }

    @Override
    public void initiateOutgoingSession(JingleTransportInitiationCallback callback) {
        LOGGER.log(Level.INFO, "Initiate Jingle InBandBytestream session.");
        try {
            InBandBytestreamSession session = InBandBytestreamManager.getByteStreamManager(this.jingleSession.getConnection()).establishSession(this.jingleSession.getRemote(), ((JingleIBBTransport)this.theirProposal).getSessionId());
            callback.onSessionInitiated(session);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            callback.onException(e);
        }
    }

    @Override
    public void initiateIncomingSession(final JingleTransportInitiationCallback callback) {
        LOGGER.log(Level.INFO, "Await Jingle InBandBytestream session.");
        InBandBytestreamManager.getByteStreamManager(this.jingleSession.getConnection()).addIncomingBytestreamListener(new BytestreamListener(){

            @Override
            public void incomingBytestreamRequest(BytestreamRequest request) {
                if (request.getFrom().asFullJidIfPossible().equals(JingleIBBTransportSession.this.jingleSession.getRemote()) && request.getSessionID().equals(((JingleIBBTransport)JingleIBBTransportSession.this.theirProposal).getSessionId())) {
                    BytestreamSession session;
                    try {
                        session = request.accept();
                    }
                    catch (InterruptedException | SmackException | XMPPException.XMPPErrorException e) {
                        callback.onException(e);
                        return;
                    }
                    callback.onSessionInitiated(session);
                }
            }
        });
    }

    @Override
    public String getNamespace() {
        return this.transportManager.getNamespace();
    }

    @Override
    public IQ handleTransportInfo(Jingle transportInfo) {
        return IQ.createResultIQ(transportInfo);
    }

    @Override
    public JingleTransportManager<JingleIBBTransport> transportManager() {
        return JingleIBBTransportManager.getInstanceFor(this.jingleSession.getConnection());
    }
}

