/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.pcap4j.util.ByteArrays;

public final class GtpV1ExtensionHeaderType
extends NamedNumber<Byte, GtpV1ExtensionHeaderType> {
    private static final long serialVersionUID = -4403955365412522031L;
    public static final GtpV1ExtensionHeaderType NO_MORE_EXTENSION_HEADERS = new GtpV1ExtensionHeaderType((byte)0, "No more extension headers");
    public static final GtpV1ExtensionHeaderType MBMS_SUPPORT_INDICATION = new GtpV1ExtensionHeaderType((byte)1, "MBMS support indication");
    public static final GtpV1ExtensionHeaderType MS_INFO_CHANGE_REPORTING_SUPPORT_INDICATION = new GtpV1ExtensionHeaderType((byte)2, "MS Info Change Reporting support indication");
    public static final GtpV1ExtensionHeaderType PDCP_PDU_NUMBER = new GtpV1ExtensionHeaderType((byte)-64, "PDCP PDU number");
    public static final GtpV1ExtensionHeaderType SUSPEND_REQUEST = new GtpV1ExtensionHeaderType((byte)-63, "Suspend Request");
    public static final GtpV1ExtensionHeaderType SUSPEND_RESPONSE = new GtpV1ExtensionHeaderType((byte)-62, "Suspend Response");
    private static final Map<Byte, GtpV1ExtensionHeaderType> registry = new HashMap<Byte, GtpV1ExtensionHeaderType>();

    public ComprehensionRequirement getComprehensionRequirement() {
        int val = (Byte)this.value() >> 6 & 3;
        return ComprehensionRequirement.values()[val];
    }

    public GtpV1ExtensionHeaderType(Byte value2, String name) {
        super(value2, name);
    }

    public static GtpV1ExtensionHeaderType getInstance(Byte value2) {
        if (registry.containsKey(value2)) {
            return registry.get(value2);
        }
        return new GtpV1ExtensionHeaderType(value2, "unknown");
    }

    public static GtpV1ExtensionHeaderType register(GtpV1ExtensionHeaderType type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return "0x" + ByteArrays.toHexString((Byte)this.value(), "");
    }

    @Override
    public int compareTo(GtpV1ExtensionHeaderType o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        registry.put((Byte)NO_MORE_EXTENSION_HEADERS.value(), NO_MORE_EXTENSION_HEADERS);
        registry.put((Byte)MBMS_SUPPORT_INDICATION.value(), MBMS_SUPPORT_INDICATION);
        registry.put((Byte)MS_INFO_CHANGE_REPORTING_SUPPORT_INDICATION.value(), MS_INFO_CHANGE_REPORTING_SUPPORT_INDICATION);
        registry.put((Byte)PDCP_PDU_NUMBER.value(), PDCP_PDU_NUMBER);
        registry.put((Byte)SUSPEND_REQUEST.value(), SUSPEND_REQUEST);
        registry.put((Byte)SUSPEND_RESPONSE.value(), SUSPEND_RESPONSE);
    }

    public static enum ComprehensionRequirement {
        NOT_REQUIRED_SHALL_FORWARD,
        NOT_REQUIRED_SHALL_DISCARD,
        REQUIRED_BY_ENDPOINT,
        REQUIRED_BY_RECIPIENT;

    }
}

