/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import java.net.IDN;
import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;
import rocks.xmpp.precis.PrecisProfile;

final class IDNProfile
extends PrecisProfile {
    private static final String DOTS = "[.\u3002\uff0e\uff61]";
    private static final Pattern LABEL_SEPARATOR = Pattern.compile("[.\u3002\uff0e\uff61]");

    IDNProfile() {
        super(false);
    }

    @Override
    public String prepare(CharSequence input) {
        return IDN.toUnicode(IDN.toASCII(input.toString(), 2), 2);
    }

    @Override
    public String enforce(CharSequence input) {
        return this.applyAdditionalMappingRule(this.applyNormalizationRule(this.applyWidthMappingRule(this.applyCaseMappingRule(this.prepare(input))))).toString();
    }

    @Override
    protected CharSequence applyWidthMappingRule(CharSequence charSequence) {
        return IDNProfile.widthMap(charSequence);
    }

    @Override
    protected CharSequence applyAdditionalMappingRule(CharSequence charSequence) {
        return LABEL_SEPARATOR.matcher(charSequence).replaceAll(".");
    }

    @Override
    protected CharSequence applyCaseMappingRule(CharSequence charSequence) {
        return charSequence.toString().toLowerCase(Locale.US);
    }

    @Override
    protected CharSequence applyNormalizationRule(CharSequence charSequence) {
        return Normalizer.normalize(charSequence, Normalizer.Form.NFC);
    }

    @Override
    protected CharSequence applyDirectionalityRule(CharSequence charSequence) {
        return charSequence;
    }
}

