/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.archive;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.StreamSource;

public class GZIPAnalyzer
extends FileAnalyzer {
    private FileAnalyzer.Genre g;
    private FileAnalyzer fa;

    @Override
    public FileAnalyzer.Genre getGenre() {
        if (this.g != null) {
            return this.g;
        }
        return super.getGenre();
    }

    protected GZIPAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        StreamSource gzSrc = GZIPAnalyzer.wrap(src);
        String path = doc.get("path");
        if (path != null && (path.endsWith(".gz") || path.endsWith(".GZ") || path.endsWith(".Gz"))) {
            String newname = path.substring(0, path.length() - 3);
            try (InputStream gzis = gzSrc.getStream();){
                this.fa = AnalyzerGuru.getAnalyzer(gzis, newname);
            }
            if (this.fa == null) {
                this.g = FileAnalyzer.Genre.DATA;
                OpenGrokLogger.getLogger().log(Level.WARNING, "Did not analyze {0}, detected as data.", newname);
            } else {
                this.g = this.fa.getGenre() == FileAnalyzer.Genre.PLAIN || this.fa.getGenre() == FileAnalyzer.Genre.XREFABLE ? FileAnalyzer.Genre.XREFABLE : FileAnalyzer.Genre.DATA;
                this.fa.analyze(doc, gzSrc, xrefOut);
                if (doc.get("t") != null) {
                    doc.removeField("t");
                    if (this.g == FileAnalyzer.Genre.XREFABLE) {
                        doc.add((IndexableField)new Field("t", this.g.typeName(), AnalyzerGuru.string_ft_stored_nanalyzed_norms));
                    }
                }
            }
        }
    }

    private static StreamSource wrap(final StreamSource src) {
        return new StreamSource(){

            @Override
            public InputStream getStream() throws IOException {
                return new BufferedInputStream(new GZIPInputStream(src.getStream()));
            }
        };
    }

    @Override
    public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        if (this.fa != null) {
            return this.fa.createComponents(fieldName, reader);
        }
        return super.createComponents(fieldName, reader);
    }
}

