/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.ParseException;
import org.opensolaris.opengrok.history.RCSRepository;
import org.opensolaris.opengrok.util.IOUtils;

public class RCSget
extends InputStream {
    private InputStream stream;

    public RCSget(String file, String version) throws IOException, FileNotFoundException {
        try {
            Archive archive = new Archive(file);
            Object[] lines = version == null ? archive.getRevision(false) : archive.getRevision(version, false);
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < lines.length; ++ii) {
                sb.append((String)lines[ii]);
                sb.append("\n");
            }
            this.stream = new ByteArrayInputStream(sb.toString().getBytes());
        }
        catch (ParseException e) {
            throw RCSRepository.wrapInIOException("Parse error", e);
        }
        catch (InvalidFileFormatException e) {
            throw RCSRepository.wrapInIOException("Invalid RCS file format", e);
        }
        catch (PatchFailedException e) {
            throw RCSRepository.wrapInIOException("Patch failed", e);
        }
        catch (NodeNotFoundException e) {
            throw RCSRepository.wrapInIOException("Revision " + version + " not found", e);
        }
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.stream);
    }

    @Override
    public void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public int read(byte[] buffer, int pos, int len) throws IOException {
        return this.stream.read(buffer, pos, len);
    }

    @Override
    public int read() throws IOException {
        throw new IOException("use a BufferedInputStream. just read() is not supported!");
    }
}

