/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.stubs.impl;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.impl.ES6FromClauseImpl;
import com.intellij.lang.ecmascript6.psi.stubs.ES6FromClauseStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class ES6FromClauseStubImpl
extends JSStubBase<ES6FromClause>
implements ES6FromClauseStub {
    @Nullable
    private final StringRef myReferencedText;

    public ES6FromClauseStubImpl(ES6FromClause psi, StubElement parent) {
        super(psi, parent, (IStubElementType)ES6ElementTypes.FROM_CLAUSE);
        this.myReferencedText = StringRef.fromString((String)psi.getReferenceText());
    }

    public ES6FromClauseStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)ES6ElementTypes.FROM_CLAUSE);
        this.myReferencedText = dataStream.readName();
    }

    public ES6FromClause createPsi() {
        return new ES6FromClauseImpl(this);
    }

    public void index(IndexSink sink) {
    }

    @Nullable
    public String getReferenceText() {
        return StringRef.toString((StringRef)this.myReferencedText);
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        ES6FromClauseStubImpl.writeString(this.myReferencedText, dataStream);
    }
}

