/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptExcludeUtil {
    private static volatile boolean FORCE_DISABLE = false;

    public static boolean areSourcesExcluded(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(0);
        }
        if (!TypeScriptExcludeUtil.isExcludingJSSourcesEnabled()) {
            return false;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file2 == null) {
            return false;
        }
        Project project = element.getProject();
        return TypeScriptExcludeUtil.areSourcesExcluded(project, file2);
    }

    public static boolean areSourcesExcluded(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile json;
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(2);
        }
        if ((json = TypeScriptExcludeUtil.findPackageJsonIfExcludingEnabled(project, file2)) == null) {
            return false;
        }
        PackageJsonData packageJson = PackageJsonData.getOrCreate(json);
        return TypeScriptExcludeUtil.arePackageSourcesExcluded(project, packageJson);
    }

    @Nullable
    public static VirtualFile findPackageJsonIfExcludingEnabled(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(4);
        }
        if (!TypeScriptExcludeUtil.checkProject(project)) {
            return null;
        }
        VirtualFile json = PackageJsonUtil.findUpPackageJson(file2);
        if (json == null || !TypeScriptUtil.isUnderNodeModules(json, project)) {
            return null;
        }
        return json;
    }

    public static boolean checkProject(@NotNull Project project) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(5);
        }
        return !project.isDisposed() && !project.isDefault();
    }

    public static boolean arePackageSourcesExcluded(@NotNull Project project, @NotNull PackageJsonData packageJson) {
        String name;
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(6);
        }
        if (packageJson == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(7);
        }
        if ((name = packageJson.getName()) == null || name.startsWith("@types/")) {
            return false;
        }
        TypeScriptExcludeManager settings = TypeScriptExcludeManager.getInstance(project);
        if (settings == null) {
            return false;
        }
        Set<String> packages = settings.getIncludedJSSourcePackages();
        if (packages.contains(name)) {
            return false;
        }
        return TypeScriptExcludeUtil.canExcludedSources(packageJson);
    }

    public static boolean isExcludingJSSourcesEnabled() {
        if (FORCE_DISABLE) {
            return false;
        }
        return Registry.is((String)"javascript.exclude.source.if.package.has.typings");
    }

    public static void forceDisableExcludingJSSource(boolean value) {
        FORCE_DISABLE = value;
    }

    public static void updateSourcesForPackage(@NotNull Project project, @NotNull String packageName, boolean include) {
        TypeScriptExcludeManager settings;
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(8);
        }
        if (packageName == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(9);
        }
        if ((settings = TypeScriptExcludeManager.getInstance(project)) == null || StringUtil.isEmpty((String)packageName) || !TypeScriptExcludeUtil.checkProject(project)) {
            return;
        }
        HashSet packages = ContainerUtil.newHashSet(settings.getIncludedJSSourcePackages());
        if (include) {
            packages.add(packageName);
        } else {
            packages.remove(packageName);
        }
        settings.setIncludedJSSourcePackages(packages);
    }

    public static boolean canExcludedSources(@NotNull PackageJsonData data) {
        if (data == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(10);
        }
        if (data.containsOneOfDependencyOfAnyType("vue", "vue-loader", "vue-latest", "vue-template-compiler")) {
            return false;
        }
        return data.hasTypings();
    }

    @NotNull
    public static PsiElement createIncludeSourcesElement(final @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(11);
        }
        final Project project = context.getProject();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context);
        assert (virtualFile != null);
        final String name = TypeScriptExcludeUtil.getPackageName(virtualFile);
        assert (name != null);
        FakePsiElement fakePsiElement = new FakePsiElement(){

            public String getName() {
                return JSBundle.message((String)"typescript.include.js.sources.element", (Object[])new Object[0]);
            }

            public PsiElement getParent() {
                return context;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.FileTypes.JavaScript;
            }

            public void navigate(boolean requestFocus) {
                if (0 != Messages.showYesNoDialog((Project)project, (String)JSBundle.message((String)"typescript.include.js.sources.dialog.message", (Object[])new Object[]{name}), (String)JSBundle.message((String)"typescript.include.js.sources.dialog.title", (Object[])new Object[]{name}), null)) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    TypeScriptExcludeUtil.updateSourcesAndRefresh(project, name, true);
                    TypeScriptExcludeUtil.runGoToImplementationInWhenSmart(project);
                }, project.getDisposed());
            }
        };
        if (fakePsiElement == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(12);
        }
        return fakePsiElement;
    }

    private static void runGoToImplementationInWhenSmart(@NotNull Project project) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(13);
        }
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            if (project == null) {
                TypeScriptExcludeUtil.$$$reportNull$$$0(18);
            }
            if (project.isDisposed()) {
                return;
            }
            String actionId = "GotoImplementation";
            AnAction implementation = ActionManager.getInstance().getAction(actionId);
            if (implementation == null) {
                Logger.getInstance(TypeScriptExcludeUtil.class).error("Cannot file go to implementation action by id " + actionId);
                return;
            }
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(data -> {
                if (project == null) {
                    TypeScriptExcludeUtil.$$$reportNull$$$0(19);
                }
                if (project.isDisposed()) {
                    return;
                }
                AnActionEvent event = new AnActionEvent(null, data, "", new DefaultActionGroup().getTemplatePresentation(), ActionManager.getInstance(), 0);
                implementation.actionPerformed(event);
            });
        });
    }

    public static void updateSourcesAndRefresh(@NotNull Project project, @NotNull String name, boolean include) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(15);
        }
        TypeScriptExcludeUtil.updateSourcesForPackage(project, name, include);
        WriteAction.run(() -> {
            if (project == null) {
                TypeScriptExcludeUtil.$$$reportNull$$$0(17);
            }
            NodeModulesDirectoryManager.getInstance(project).resetSnapshot();
            JSLibraryManager.getInstance(project).commitChanges();
        });
    }

    public static String getPackageName(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(16);
        }
        VirtualFile json = PackageJsonUtil.findUpPackageJson(virtualFile);
        assert (json != null);
        PackageJsonData packageJson = PackageJsonData.getOrCreate(json);
        return packageJson.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptExcludeUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptExcludeUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createIncludeSourcesElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areSourcesExcluded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPackageJsonIfExcludingEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "arePackageSourcesExcluded";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateSourcesForPackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canExcludedSources";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createIncludeSourcesElement";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runGoToImplementationInWhenSmart";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateSourcesAndRefresh";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateSourcesAndRefresh$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runGoToImplementationInWhenSmart$1";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

