/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.run;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.behat.BehatUtil;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

public class BehatRunConfigurationHandler
implements PhpTestRunConfigurationHandler {
    private static final Logger LOG = Logger.getInstance(BehatRunConfigurationHandler.class);
    private static final BehatRunConfigurationHandler ourInstance = new BehatRunConfigurationHandler();
    private static final String BEHAT_HELPER_ENV_DIR = "IDE_BEHAT_DIR";
    private static final String BEHAT_HELPER_ENV_PHAR = "IDE_BEHAT_PHAR";
    private static final String BEHAT_HELPER_ENV_VERSION = "IDE_BEHAT_VERSION";
    private static final String PHPSTORM_FORMATTER_CLASS = "PhpStormBehatFormatter";

    public static BehatRunConfigurationHandler getInstance() {
        return ourInstance;
    }

    @NotNull
    public String getConfigFileOption() {
        if ("--config" == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(0);
        }
        return "--config";
    }

    public void prepareCommand(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String exe, @Nullable String version) throws ExecutionException {
        String scriptFile;
        if (project == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(2);
        }
        if (exe == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(scriptFile = PhpExecutionUtil.loadHelperScriptAndGetText((Project)project, (String)"behat.php", (PhpCommandSettings)command, BehatRunConfigurationHandler.class)))) {
            throw new ExecutionException(PhpBundle.message((String)"php.interpreter.base.configuration.interpreter.is.invalid", (Object[])new Object[]{"Behat tests", "Behat"}));
        }
        command.setScript(scriptFile, false);
        command.addArgument("--format");
        command.addArgument(PHPSTORM_FORMATTER_CLASS);
        if (StringUtil.endsWith((CharSequence)exe, (CharSequence)".phar")) {
            command.addEnv(BEHAT_HELPER_ENV_PHAR, exe);
        } else {
            command.addEnv(BEHAT_HELPER_ENV_DIR, exe);
        }
        if (StringUtil.isNotEmpty((String)version)) {
            command.addEnv(BEHAT_HELPER_ENV_VERSION, version);
            if (version.charAt(0) != '2') {
                command.addArgument("--no-interaction");
            }
        }
    }

    public void runType(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String type, @NotNull String workingDirectory) throws ExecutionException {
        if (project == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(5);
        }
        if (type == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(7);
        }
        throw new ExecutionException(PhpBundle.message((String)"php.test.framework.validation.run.configuration.unsupported.type", (Object[])new Object[]{type}));
    }

    public void runDirectory(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String directory, @NotNull String workingDirectory) throws ExecutionException {
        if (project == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(8);
        }
        if (command == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(9);
        }
        if (directory == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(10);
        }
        if (workingDirectory == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(11);
        }
        command.addPathArgument(directory);
    }

    public void runFile(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String file, @NotNull String workingDirectory) throws ExecutionException {
        if (project == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(12);
        }
        if (command == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(14);
        }
        if (workingDirectory == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(15);
        }
        command.addPathArgument(file);
    }

    public void runMethod(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String filePath, @NotNull String methodName, @NotNull String workingDirectory) throws ExecutionException {
        PsiFile file;
        if (project == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(16);
        }
        if (command == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(18);
        }
        if (methodName == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(19);
        }
        if (workingDirectory == null) {
            BehatRunConfigurationHandler.$$$reportNull$$$0(20);
        }
        if (StringUtil.isNotEmpty((String)filePath) && (file = PhpRunUtil.findPsiFile((Project)project, (String)filePath, (boolean)true)) != null) {
            int line;
            GherkinStepsHolder scenario = BehatUtil.findScenarioByName(file, methodName);
            int n = line = scenario == null ? -1 : BehatUtil.getScenarioStartLine(project, scenario);
            if (line < 0) {
                LOG.warn("Can not find scenario '" + methodName + "' in " + filePath);
            }
            command.addPathArgument(filePath, ":" + line);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/run/BehatRunConfigurationHandler";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exe";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFileOption";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/run/BehatRunConfigurationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

