/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.behat.BehatBundle;
import com.jetbrains.php.behat.BehatContextRoot;
import com.jetbrains.php.behat.BehatUtil;
import com.jetbrains.php.behat.steps.generation.BehatStepDefinitionsFactory;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class BehatStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.behat.steps.BehatStepDefinitionCreator");
    private static final String PHP_FILE_EXTENSION = '.' + PhpFileType.INSTANCE.getDefaultExtension();
    private static final PhpClassReferenceResolver myReferenceResolver = new PhpClassReferenceResolver(){

        protected void processReference(@NotNull String name, @NotNull String fqn, @NotNull PsiElement identifier) {
            String resolvedFqn;
            Collection classes;
            if (name == null) {
                1.$$$reportNull$$$0(0);
            }
            if (fqn == null) {
                1.$$$reportNull$$$0(1);
            }
            if (identifier == null) {
                1.$$$reportNull$$$0(2);
            }
            if ((classes = PhpIndex.getInstance((Project)identifier.getProject()).getClassesByName(name)).size() == 1 && StringUtil.isNotEmpty((String)(resolvedFqn = ((PhpClass)classes.iterator().next()).getFQN()))) {
                super.processReference(name, resolvedFqn, identifier);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fqn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "identifier";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/behat/steps/BehatStepDefinitionCreator$1";
            objectArray[2] = "processReference";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        String fileName;
        PsiFile file;
        if (dir == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        if ((file = dir.findFile(fileName = name + PHP_FILE_EXTENSION)) != null) {
            PhpClass clazz;
            String pathToDir = dir.getVirtualFile().getPresentableUrl();
            if (file instanceof PhpFile && (clazz = PhpPsiUtil.findClass((PhpFile)((PhpFile)file), aClass -> {
                if (name == null) {
                    BehatStepDefinitionCreator.$$$reportNull$$$0(19);
                }
                return PhpLangUtil.equalsClassNames((CharSequence)aClass.getName(), (CharSequence)name);
            })) != null) {
                LOG.info(BehatBundle.message("php.behat.step.definition.creator.file.already.exists", name, pathToDir));
                PsiFile psiFile = file;
                if (psiFile == null) {
                    BehatStepDefinitionCreator.$$$reportNull$$$0(2);
                }
                return psiFile;
            }
            throw new RuntimeException(BehatBundle.message("php.behat.step.definition.creator.can.not.create.container", name, pathToDir));
        }
        Project project = dir.getProject();
        StringBuilder content = new StringBuilder();
        content.append("/** empty */\nclass ");
        content.append(name);
        BehatContextRoot root = BehatStepDefinitionCreator.getContextRoot(project);
        if (root.isInterface()) {
            content.append(" implements ");
        } else {
            content.append(" extends ");
        }
        content.append(PhpLangUtil.toShortName((String)root.getFqn()));
        content.append(" {\n}");
        PhpClass clazz = (PhpClass)PhpPsiElementFactory.createPhpPsiFromText((Project)project, PhpClass.class, (String)content.toString());
        PsiFile newFile = PhpFileCreator.createPhpFileWithContent((Project)project, (PsiDirectory)dir, (String)fileName, (PsiElement)clazz);
        WriteAction.run(() -> BehatStepDefinitionCreator.tuneStepDefinitionContainer(project, root, newFile));
        PhpCodeUtil.openRelatedFile((Project)project, (PsiElement)newFile);
        PsiFile psiFile = newFile;
        if (psiFile == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    private static void tuneStepDefinitionContainer(Project project, BehatContextRoot root, PsiFile newFile) {
        if (newFile instanceof PhpFile) {
            PhpAliasImporter.insertUseStatement((String)root.getFqn(), (PhpPsiElement)((PhpFile)newFile));
            Collection classes = PhpPsiUtil.findAllClasses((PhpFile)((PhpFile)newFile));
            assert (classes.size() == 1);
            PhpDocComment comment = ((PhpClass)classes.iterator().next()).getDocComment();
            if (comment != null) {
                comment.delete();
            }
        }
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(newFile.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newFile);
    }

    @NotNull
    private static BehatContextRoot getContextRoot(@NotNull Project project) {
        if (project == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        for (BehatContextRoot root : BehatContextRoot.values()) {
            Collection contextRoot = root.isInterface() ? PhpIndex.getInstance((Project)project).getInterfacesByFQN(root.getFqn()) : PhpIndex.getInstance((Project)project).getClassesByFQN(root.getFqn());
            if (contextRoot.isEmpty()) continue;
            BehatContextRoot behatContextRoot = root;
            if (behatContextRoot == null) {
                BehatStepDefinitionCreator.$$$reportNull$$$0(5);
            }
            return behatContextRoot;
        }
        BehatContextRoot behatContextRoot = BehatContextRoot.CONTEXT_CLASS;
        if (behatContextRoot == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        return behatContextRoot;
    }

    @Nullable
    private static PhpClass findClass(@NotNull Project project, @NotNull PhpFile file) {
        Collection allClasses;
        if (project == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        if ((allClasses = PhpPsiUtil.findAllClasses((PhpFile)file)).isEmpty()) {
            return null;
        }
        if (allClasses.size() == 1) {
            return (PhpClass)allClasses.iterator().next();
        }
        PhpClass contextInterface = BehatUtil.getContextInterface(project);
        for (PhpClass clazz : allClasses) {
            if (!BehatUtil.isContextClass(contextInterface, clazz)) continue;
            return clazz;
        }
        return (PhpClass)allClasses.iterator().next();
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        if (step == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(9);
        }
        if (file == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(10);
        }
        if (!(file instanceof PhpFile)) {
            return false;
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        try {
            Method method2;
            this.closeActiveTemplateBuilders(file);
            PhpClass clazz = BehatStepDefinitionCreator.findClass(project, (PhpFile)file);
            if (clazz == null) {
                throw new ExecutionException(BehatBundle.message("php.behat.step.definition.creator.can.not.find.class.in.the.file", file.getVirtualFile().getPath()));
            }
            THashSet methodNames = new THashSet();
            Collection methods = clazz.getMethods();
            for (Method method2 : methods) {
                methodNames.add(StringUtil.toLowerCase((String)method2.getName()));
            }
            String snippet = BehatStepDefinitionsFactory.getInstance().makeSnippet(step, (Set<String>)methodNames);
            method2 = PhpPsiElementFactory.createMethod((Project)project, (String)snippet);
            myReferenceResolver.processElement((PsiElement)method2, false);
            PsiElement inserted = PhpCodeEditUtil.insertClassMemberWithPhpDoc((PhpClass)clazz, (PsiElement)method2, (PhpDocComment)method2.getDocComment());
            inserted = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)inserted);
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)inserted);
            if (scope != null) {
                myReferenceResolver.importReferences(scope, inserted);
            }
            if (editor != null) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            }
            PhpCodeUtil.openRelatedFile((Project)project, (PsiElement)inserted);
        }
        catch (ExecutionException e) {
            String message = BehatBundle.message("php.behat.step.definition.creator.can.not.generate.caused", e.getMessage());
            BehatUtil.showErrorNotification(project, "", message);
        }
        return true;
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(12);
        }
        return true;
    }

    @NotNull
    public PsiDirectory getDefaultStepDefinitionFolder(@NotNull GherkinStep step) {
        PsiFile featureFile;
        PsiDirectory dir;
        if (step == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(13);
        }
        if ((dir = BehatStepDefinitionCreator.findStepDefinitionDirectory(featureFile = step.getContainingFile())) == null) {
            PsiDirectory featureParentDir = featureFile.getParent();
            assert (featureParentDir != null);
            Ref dirRef = new Ref();
            WriteCommandAction.writeCommandAction((Project)step.getProject()).withName(CucumberBundle.message((String)"cucumber.quick.fix.create.step.command.name.add", (Object[])new Object[0])).run(() -> dirRef.set((Object)featureParentDir.createSubdirectory("bootstrap")));
            PsiDirectory psiDirectory = (PsiDirectory)dirRef.get();
            if (psiDirectory == null) {
                BehatStepDefinitionCreator.$$$reportNull$$$0(14);
            }
            return psiDirectory;
        }
        PsiDirectory psiDirectory = dir;
        if (psiDirectory == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(15);
        }
        return psiDirectory;
    }

    @Nullable
    private static PsiDirectory findStepDefinitionDirectory(@NotNull PsiFile featureFile) {
        VirtualFile stepsDir;
        VirtualFile featureDir;
        if (featureFile == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(16);
        }
        PsiDirectory psiFeatureDir = featureFile.getContainingDirectory();
        assert (psiFeatureDir != null);
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)featureFile.getProject()).getFileIndex().getContentRootForFile(featureDir);
        for (featureDir = psiFeatureDir.getVirtualFile(); featureDir != null && !Comparing.equal((Object)featureDir, (Object)contentRoot) && featureDir.findChild("bootstrap") == null; featureDir = featureDir.getParent()) {
        }
        if (featureDir != null && (stepsDir = featureDir.findChild("bootstrap")) != null) {
            return featureFile.getManager().findDirectory(stepsDir);
        }
        return null;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(17);
        }
        if ("FeatureContext" == null) {
            BehatStepDefinitionCreator.$$$reportNull$$$0(18);
        }
        return "FeatureContext";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/steps/BehatStepDefinitionCreator";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/steps/BehatStepDefinitionCreator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextRoot";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepDefinitionFolder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContextRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepDefinitionFolder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinitionDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createStepDefinitionContainer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

