/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeComboBox
extends ComboBoxWithWidePopup {
    private static final int INDENT = UIUtil.getTreeLeftChildIndent();
    private TreeModel myTreeModel;
    private final String myDefaultText;
    private final boolean myShowRootNode;

    public TreeComboBox(@NotNull TreeModel model) {
        if (model == null) {
            TreeComboBox.$$$reportNull$$$0(0);
        }
        this(model, true);
    }

    public TreeComboBox(@NotNull TreeModel model, boolean showRootNode) {
        if (model == null) {
            TreeComboBox.$$$reportNull$$$0(1);
        }
        this(model, showRootNode, null);
    }

    public TreeComboBox(@NotNull TreeModel model, boolean showRootNode, String defaultText) {
        if (model == null) {
            TreeComboBox.$$$reportNull$$$0(2);
        }
        this.myTreeModel = model;
        this.myDefaultText = defaultText;
        this.myShowRootNode = showRootNode;
        this.setModel(new TreeModelWrapper(this.myTreeModel, showRootNode));
        this.setRenderer(new TreeListCellRenderer(this, showRootNode, defaultText));
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    public void setTreeModel(@NotNull TreeModel model, boolean showRootNode) {
        if (model == null) {
            TreeComboBox.$$$reportNull$$$0(3);
        }
        this.myTreeModel = model;
        this.setModel(new TreeModelWrapper(model, showRootNode));
    }

    public TreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public JTree createFakeTree() {
        JTree tree = new JTree(this.getTreeModel());
        tree.setRootVisible(this.myShowRootNode);
        return tree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/intellij/openapi/ui/TreeComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTreeModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface CustomPresentation {
        public void append(SimpleColoredComponent var1, int var2);

        public Icon getIcon(int var1, @Iconable.IconFlags int var2);
    }

    private static class PreorderEnumeration
    implements Enumeration {
        private final TreeModel myTreeModel;
        private final Stack<Enumeration> myStack;

        PreorderEnumeration(@NotNull TreeModel treeModel) {
            if (treeModel == null) {
                PreorderEnumeration.$$$reportNull$$$0(0);
            }
            this.myTreeModel = treeModel;
            this.myStack = new Stack();
            this.myStack.push(Collections.enumeration(Collections.singleton(treeModel.getRoot())));
        }

        @Override
        public boolean hasMoreElements() {
            return !this.myStack.empty() && ((Enumeration)this.myStack.peek()).hasMoreElements();
        }

        public Object nextElement() {
            ChildrenEnumeration children;
            Enumeration e = (Enumeration)this.myStack.peek();
            Object node = e.nextElement();
            if (!e.hasMoreElements()) {
                this.myStack.pop();
            }
            if ((children = new ChildrenEnumeration(this.myTreeModel, node)).hasMoreElements()) {
                this.myStack.push((Object)children);
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/openapi/ui/TreeComboBox$PreorderEnumeration", "<init>"));
        }
    }

    private static class ChildrenEnumeration
    implements Enumeration {
        private final TreeModel myTreeModel;
        private final Object myNode;
        private int myIndex;

        ChildrenEnumeration(@NotNull TreeModel treeModel, @NotNull Object node) {
            if (treeModel == null) {
                ChildrenEnumeration.$$$reportNull$$$0(0);
            }
            if (node == null) {
                ChildrenEnumeration.$$$reportNull$$$0(1);
            }
            this.myIndex = -1;
            this.myTreeModel = treeModel;
            this.myNode = node;
        }

        @Override
        public boolean hasMoreElements() {
            return this.myIndex < this.myTreeModel.getChildCount(this.myNode) - 1;
        }

        public Object nextElement() {
            return this.myTreeModel.getChild(this.myNode, ++this.myIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "treeModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/ui/TreeComboBox$ChildrenEnumeration";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TreeModelWrapper
    extends AbstractListModel
    implements ComboBoxModel {
        private final TreeModel myTreeModel;
        private Object mySelectedItem;
        private final boolean myShowRootNode;
        private final List<TreeNode> myTreeModelAsList;

        private TreeModelWrapper(@NotNull TreeModel treeModel, boolean showRootNode) {
            if (treeModel == null) {
                TreeModelWrapper.$$$reportNull$$$0(0);
            }
            this.myTreeModelAsList = new ArrayList<TreeNode>();
            this.myTreeModel = treeModel;
            this.myShowRootNode = showRootNode;
            TreeModelWrapper.accumulateChildren((TreeNode)treeModel.getRoot(), this.myTreeModelAsList, showRootNode);
        }

        public TreeModel getTreeModel() {
            return this.myTreeModel;
        }

        @Override
        public void setSelectedItem(Object obj) {
            if (this.mySelectedItem != null && !this.mySelectedItem.equals(obj) || this.mySelectedItem == null && obj != null) {
                this.mySelectedItem = obj;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        private static void accumulateChildren(@NotNull TreeNode node, @NotNull List<? super TreeNode> list, boolean showRoot) {
            if (node == null) {
                TreeModelWrapper.$$$reportNull$$$0(1);
            }
            if (list == null) {
                TreeModelWrapper.$$$reportNull$$$0(2);
            }
            if (showRoot || node.getParent() != null) {
                list.add(node);
            }
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                TreeModelWrapper.accumulateChildren(node.getChildAt(i), list, showRoot);
            }
        }

        private TreePath getPathForRow(int row) {
            ArrayList<TreeNode> path2 = new ArrayList<TreeNode>();
            for (TreeNode node = this.myTreeModelAsList.get(row); node != null; node = node.getParent()) {
                path2.add(0, node);
            }
            return new TreePath(path2.toArray(new TreeNode[0]));
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public int getSize() {
            int count = 0;
            PreorderEnumeration e = new PreorderEnumeration(this.myTreeModel);
            while (e.hasMoreElements()) {
                e.nextElement();
                ++count;
            }
            return count - (this.myShowRootNode ? 0 : 1);
        }

        @Override
        public Object getElementAt(int index2) {
            PreorderEnumeration e = new PreorderEnumeration(this.myTreeModel);
            if (!this.myShowRootNode) {
                ++index2;
            }
            for (int i = 0; i < index2; ++i) {
                e.nextElement();
            }
            return e.nextElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/ui/TreeComboBox$TreeModelWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accumulateChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TreeListCellRenderer
    extends SimpleColoredRenderer
    implements ListCellRenderer {
        private static final Border SELECTION_PAINTER = (Border)UIManager.get("MenuItem.selectedBackgroundPainter");
        private boolean mySelected;
        private boolean myInList;
        private final JComboBox myComboBox;
        private boolean myChecked;
        private boolean myEditable;
        private final boolean myUnderAquaLookAndFeel;
        private final boolean myShowRootNode;
        private final String myDefaultText;

        private TreeListCellRenderer(@NotNull JComboBox comboBox, boolean showRootNode, @Nullable String defaultText) {
            if (comboBox == null) {
                TreeListCellRenderer.$$$reportNull$$$0(0);
            }
            this.myComboBox = comboBox;
            this.myShowRootNode = showRootNode;
            this.myDefaultText = defaultText;
            this.myUnderAquaLookAndFeel = UIUtil.isUnderAquaLookAndFeel();
            this.setOpaque(!this.myUnderAquaLookAndFeel);
        }

        private static Icon getValueIcon(Object value, int index2) {
            if (value instanceof CustomPresentation) {
                return ((CustomPresentation)value).getIcon(index2, 0);
            }
            if (value instanceof Iconable) {
                return ((Iconable)value).getIcon(0);
            }
            return null;
        }

        private TreeModelWrapper getTreeModelWrapper() {
            return (TreeModelWrapper)this.myComboBox.getModel();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
            Object obj1;
            this.clear();
            boolean bl = this.myInList = index2 >= 0;
            this.myChecked = index2 >= 0 ? (obj1 = this.myComboBox.getItemAt(index2)) != null && obj1.equals(this.myComboBox.getSelectedItem()) : false;
            int indent = 0;
            if (this.myInList) {
                TreePath path2 = this.getTreeModelWrapper().getPathForRow(index2);
                int n = path2 == null ? 0 : (indent = (path2.getPathCount() - 1 - (this.myShowRootNode ? 0 : 1)) * (UIUtil.isUnderAquaLookAndFeel() ? 2 : 1) * INDENT);
            }
            this.setIpad(new Insets(1, !this.myInList || this.myEditable ? (this.myUnderAquaLookAndFeel ? 0 : 5) : (this.myUnderAquaLookAndFeel ? 23 : 5) + indent, 1, 5));
            this.setIcon(TreeListCellRenderer.getValueIcon(value, index2));
            this.setIconOpaque(!this.myUnderAquaLookAndFeel);
            this.myEditable = this.myComboBox.isEditable();
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            if (!this.myUnderAquaLookAndFeel) {
                this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            }
            if (value instanceof CustomPresentation) {
                ((CustomPresentation)value).append(this, index2);
            } else if (value == null) {
                if (index2 == -1 && this.myDefaultText != null) {
                    this.append(this.myDefaultText, SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    this.append("");
                }
            } else {
                this.append(value.toString());
            }
            this.setSelected(isSelected);
            this.setFont(list.getFont());
            return this;
        }

        private void setSelected(boolean selected) {
            this.mySelected = selected;
        }

        @Override
        protected boolean shouldPaintBackground() {
            return !this.myUnderAquaLookAndFeel;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.myUnderAquaLookAndFeel) {
                if (this.mySelected) {
                    SELECTION_PAINTER.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
                }
                if (SystemInfo.isMac && this.myChecked && !this.myEditable) {
                    int i = this.getHeight() - 4;
                    g.setColor(this.getForeground());
                    g.drawString("\u2713", 6, i);
                }
            }
            super.paintComponent(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/openapi/ui/TreeComboBox$TreeListCellRenderer", "<init>"));
        }
    }
}

