/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Experimental
public abstract class YamlScalarType
extends YamlMetaType {
    protected YamlScalarType(@NotNull String typeName) {
        if (typeName == null) {
            YamlScalarType.$$$reportNull$$$0(0);
        }
        super(typeName);
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        if (name == null) {
            YamlScalarType.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PlatformIcons.PROPERTY_ICON;
        if (icon == null) {
            YamlScalarType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Override
    public void validateKeyValue(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        YAMLValue value;
        if (keyValue == null) {
            YamlScalarType.$$$reportNull$$$0(3);
        }
        if (problemsHolder == null) {
            YamlScalarType.$$$reportNull$$$0(4);
        }
        if ((value = keyValue.getValue()) == null) {
            return;
        }
        if (value instanceof YAMLScalar) {
            this.validateScalarValue((YAMLScalar)value, problemsHolder);
        } else if (value instanceof YAMLSequence) {
            for (YAMLSequenceItem nextItem : ((YAMLSequence)value).getItems()) {
                YAMLValue nextValue = nextItem.getValue();
                if (!(nextValue instanceof YAMLScalar)) continue;
                this.validateScalarValue((YAMLScalar)nextValue, problemsHolder);
            }
        } else if (value instanceof YAMLCompoundValue) {
            problemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlScalarType.error.scalar.value"), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue == null) {
            YamlScalarType.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            YamlScalarType.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    public List<? extends LookupElement> getValueLookups(@NotNull YAMLScalar context) {
        if (context == null) {
            YamlScalarType.$$$reportNull$$$0(7);
        }
        List list = Collections.emptyList();
        if (list == null) {
            YamlScalarType.$$$reportNull$$$0(8);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            YamlScalarType.$$$reportNull$$$0(9);
        }
        if (relation == null) {
            YamlScalarType.$$$reportNull$$$0(10);
        }
        if (iteration == null) {
            YamlScalarType.$$$reportNull$$$0(11);
        }
        switch (relation) {
            case OBJECT_CONTENTS: 
            case SCALAR_VALUE: {
                markup.append(": ");
                if (!iteration.isEndOfPathReached()) break;
                markup.appendCaret();
                break;
            }
            case SEQUENCE_ITEM: {
                markup.append(":");
                markup.increaseTabs(2);
                try {
                    markup.newLineAndTabs(true);
                    if (!iteration.isEndOfPathReached()) break;
                    markup.appendCaret();
                    break;
                }
                finally {
                    markup.decreaseTabs(2);
                }
            }
            default: {
                throw new IllegalStateException("Unknown relation: " + (Object)((Object)relation));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlScalarType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scalarValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlScalarType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLookups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFeatureByName";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateKeyValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateScalarValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueLookups";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildInsertionSuffixMarkup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

