/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.dialog;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.find.FindSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CustomScopeItem
implements ModelScopeItem {
    private final Project myProject;
    private boolean mySearchInLib;
    private String myPreselect;
    private Supplier<? extends SearchScope> mySupplierScope;

    public CustomScopeItem(Project project, @Nullable PsiElement context) {
        this.myProject = project;
        AnalysisUIOptions options = AnalysisUIOptions.getInstance(project);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)context);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.mySearchInLib = file2 != null && (fileIndex.isInLibraryClasses(file2) || fileIndex.isInLibrarySource(file2));
        String string = this.myPreselect = StringUtil.isEmptyOrSpaces((String)options.CUSTOM_SCOPE_NAME) ? FindSettings.getInstance().getDefaultScopeName() : options.CUSTOM_SCOPE_NAME;
        if (this.mySearchInLib && GlobalSearchScope.projectScope((Project)this.myProject).getDisplayName().equals(this.myPreselect)) {
            this.myPreselect = GlobalSearchScope.allScope((Project)this.myProject).getDisplayName();
        }
        if (GlobalSearchScope.allScope((Project)this.myProject).getDisplayName().equals(this.myPreselect) && options.SCOPE_TYPE == 8) {
            options.CUSTOM_SCOPE_NAME = this.myPreselect;
            this.mySearchInLib = true;
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean getSearchInLibFlag() {
        return this.mySearchInLib;
    }

    public String getPreselectedCustomScope() {
        return this.myPreselect;
    }

    @Override
    public AnalysisScope getScope() {
        if (this.mySupplierScope != null) {
            return new AnalysisScope(this.mySupplierScope.get(), this.myProject);
        }
        return null;
    }

    public void setSearchScopeSupplier(Supplier<? extends SearchScope> supplier) {
        this.mySupplierScope = supplier;
    }
}

