/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.FeatureUsageEventLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.FeatureUsageFileEventLogger;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogEventWriter;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\b*\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageFileEventLoggerProvider;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventLoggerProvider;", "()V", "createLogger", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventLogger;", "isEnabled", "", "asBuildNumber", "", "Lcom/intellij/openapi/util/BuildNumber;", "shortedUUID", "intellij.platform.ide.impl"})
public final class FeatureUsageFileEventLoggerProvider
implements FeatureUsageEventLoggerProvider {
    @NotNull
    public FeatureUsageEventLogger createLogger() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        String sessionId = this.shortedUUID(string);
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        String build2 = this.asBuildNumber(buildNumber);
        FeatureUsageFileEventLogger logger = new FeatureUsageFileEventLogger(sessionId, build2, "-1", "9", new FeatureUsageLogEventWriter());
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(logger){
            final /* synthetic */ FeatureUsageFileEventLogger $logger;

            public void applicationExiting() {
                this.$logger.dispose();
            }
            {
                this.$logger = $captured_local_variable$0;
            }
        });
        return logger;
    }

    private final String shortedUUID(@NotNull String $receiver) {
        int start2 = StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start2 > 0 && start2 + 1 < $receiver.length()) {
            String string = $receiver;
            int n = start2 + 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $receiver;
    }

    private final String asBuildNumber(@NotNull BuildNumber $receiver) {
        String str;
        String string = str = $receiver.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
        return StringsKt.endsWith$default((String)string, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabled() {
        if (!StatisticsUploadAssistant.isSendAllowed()) return false;
        if (!Registry.is((String)"feature.usage.event.log.collect.and.upload")) return false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) return false;
        return true;
    }
}

