/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

class CreateXmlElementIntentionAction
implements IntentionAction {
    private final String myMessageKey;
    protected final TypeOrElementOrAttributeReference myRef;
    private boolean myIsAvailableEvaluated;
    private XmlFile myTargetFile;
    private final String myDeclarationTagName;

    CreateXmlElementIntentionAction(@PropertyKey(resourceBundle="messages.XmlBundle") String messageKey, @NonNls @NotNull String declarationTagName, TypeOrElementOrAttributeReference ref) {
        if (declarationTagName == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(0);
        }
        this.myMessageKey = messageKey;
        this.myRef = ref;
        this.myDeclarationTagName = declarationTagName;
    }

    @NotNull
    public String getText() {
        String string = XmlBundle.message((String)this.myMessageKey, (Object[])new Object[]{XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText())});
        if (string == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"xml.create.xml.declaration.intention.type", (Object[])new Object[0]);
        if (string == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(3);
        }
        if (!this.myIsAvailableEvaluated) {
            XsdNsDescriptor descriptor;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myRef.getElement(), XmlTag.class);
            if (tag != null && (descriptor = this.myRef.getDescriptor(tag, this.myRef.getCanonicalText(), new boolean[1])) != null && descriptor.getDescriptorFile() != null && descriptor.getDescriptorFile().isWritable()) {
                this.myTargetFile = descriptor.getDescriptorFile();
            }
            this.myIsAvailableEvaluated = true;
        }
        return this.myTargetFile != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            CreateXmlElementIntentionAction.$$$reportNull$$$0(4);
        }
        XmlTag rootTag = this.myTargetFile.getDocument().getRootTag();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.myTargetFile.getVirtualFile(), rootTag.getValue().getTextRange().getEndOffset());
        Editor targetEditor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        TemplateManager manager = TemplateManager.getInstance(project);
        Template template = manager.createTemplate("", "");
        this.addTextTo(template, rootTag);
        manager.startTemplate(targetEditor, template);
    }

    protected void addTextTo(Template template, XmlTag rootTag) {
        String schemaPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema");
        if (!schemaPrefix.isEmpty()) {
            schemaPrefix = schemaPrefix + ":";
        }
        template.addTextSegment("<" + schemaPrefix + this.myDeclarationTagName + " name=\"" + XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText()) + "\">");
        template.addEndVariable();
        template.addTextSegment("</" + schemaPrefix + this.myDeclarationTagName + ">\n");
        template.setToReformat(true);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationTagName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

