/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsLogColorManagerImpl
implements VcsLogColorManager {
    private static final Logger LOG = Logger.getInstance(VcsLogColorManagerImpl.class);
    private static final Color[] ROOT_COLORS = new Color[]{JBColor.RED, JBColor.GREEN, JBColor.BLUE, JBColor.ORANGE, JBColor.CYAN, JBColor.YELLOW, JBColor.MAGENTA, JBColor.PINK};
    @NotNull
    private final List<VirtualFile> myRoots;
    @NotNull
    private final Map<VirtualFile, Color> myRoots2Colors;

    public VcsLogColorManagerImpl(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myRoots = new ArrayList<VirtualFile>(roots);
        Collections.sort(this.myRoots, Comparator.comparing(VirtualFile::getName));
        this.myRoots2Colors = ContainerUtil.newHashMap();
        int i = 0;
        for (VirtualFile root : this.myRoots) {
            Color color;
            if (i >= ROOT_COLORS.length) {
                double balance = (double)(i / ROOT_COLORS.length) / (double)(roots.size() / ROOT_COLORS.length);
                Color mix = ColorUtil.mix((Color)ROOT_COLORS[i % ROOT_COLORS.length], (Color)ROOT_COLORS[(i + 1) % ROOT_COLORS.length], (double)balance);
                int tones = (int)(Math.abs(balance - 0.5) * 2.0 * (double)(roots.size() / ROOT_COLORS.length) + 1.0);
                color = new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
            } else {
                color = ROOT_COLORS[i];
            }
            ++i;
            this.myRoots2Colors.put(root, color);
        }
    }

    @NotNull
    public static JBColor getBackgroundColor(@NotNull Color baseRootColor) {
        if (baseRootColor == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(1);
        }
        JBColor jBColor = new JBColor(() -> {
            if (baseRootColor == null) {
                VcsLogColorManagerImpl.$$$reportNull$$$0(5);
            }
            return ColorUtil.mix((Color)baseRootColor, (Color)UIUtil.getTableBackground(), (double)0.75);
        });
        if (jBColor == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(2);
        }
        return jBColor;
    }

    @Override
    public boolean isMultipleRoots() {
        return this.myRoots.size() > 1;
    }

    @Override
    @NotNull
    public Color getRootColor(@NotNull VirtualFile root) {
        Color color;
        if (root == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(3);
        }
        if ((color = this.myRoots2Colors.get(root)) == null) {
            LOG.error("No color record for root " + root + ". All roots: " + this.myRoots2Colors);
            color = VcsLogColorManagerImpl.getDefaultRootColor();
        }
        Color color2 = color;
        if (color2 == null) {
            VcsLogColorManagerImpl.$$$reportNull$$$0(4);
        }
        return color2;
    }

    private static Color getDefaultRootColor() {
        return UIUtil.getTableBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRootColor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogColorManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogColorManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootColor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getBackgroundColor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

