/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.InjectorMatchingEndFinder;
import org.jetbrains.annotations.NotNull;

public abstract class StringInjectionsProcessor {
    @NotNull
    private final String myStart;
    @NotNull
    private final String myEnd;
    @NotNull
    private final String myText;

    public StringInjectionsProcessor(@NotNull String start, @NotNull String end, @NotNull String text) {
        if (start == null) {
            StringInjectionsProcessor.$$$reportNull$$$0(0);
        }
        if (end == null) {
            StringInjectionsProcessor.$$$reportNull$$$0(1);
        }
        if (text == null) {
            StringInjectionsProcessor.$$$reportNull$$$0(2);
        }
        this.myStart = start;
        this.myEnd = end;
        this.myText = text;
    }

    public void process() {
        int currentPos = 0;
        while (currentPos < this.myText.length()) {
            int startInjection = this.myText.indexOf(this.myStart, currentPos);
            if (startInjection < 0) {
                this.onText(this.myText.substring(currentPos));
                return;
            }
            int afterStart = startInjection + this.myStart.length();
            int endInjection = InjectorMatchingEndFinder.findMatchingEnd(this.myStart, this.myEnd, this.myText, afterStart);
            if (endInjection < 0) {
                this.onInjection(this.myText.substring(currentPos));
                return;
            }
            if (!this.onText(this.myText.substring(currentPos, startInjection))) {
                return;
            }
            if (!this.onInjection(this.myText.substring(startInjection, endInjection + this.myEnd.length()))) {
                return;
            }
            currentPos = endInjection + this.myEnd.length();
        }
    }

    protected abstract boolean onText(@NotNull String var1);

    protected abstract boolean onInjection(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "end";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/util/text/StringInjectionsProcessor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

