/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util.diff;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.ast.ILocalScope;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.rewriter.ReWriteVisitor;
import org.jrubyparser.util.diff.Change;
import org.jrubyparser.util.diff.DeepDiff;
import org.jrubyparser.util.diff.IsJunk;
import org.jrubyparser.util.diff.SequenceMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDiff {
    protected List<Change> diff = new ArrayList<Change>();
    protected List<DeepDiff> deepdiff = new ArrayList<DeepDiff>();
    protected SequenceMatcher SequenceMatch;
    protected String oldDocument;
    protected String newDocument;
    protected Node newNode;
    protected Node oldNode;
    protected IsJunk isJunk;

    public NodeDiff(Node newNode, Node oldNode) {
        this(newNode, oldNode, null);
    }

    public NodeDiff(Node newNode, Node oldNode, IsJunk isJunk) {
        this.newNode = newNode;
        this.oldNode = oldNode;
        this.isJunk = isJunk;
    }

    public NodeDiff(Node newNode, String newDocument, Node oldNode, String oldDocument) {
        this(newNode, newDocument, oldNode, oldDocument, null);
    }

    public NodeDiff(Node newNode, String newDocument, Node oldNode, String oldDocument, IsJunk isJunk) {
        this.newNode = newNode;
        this.newDocument = newDocument;
        this.oldNode = oldNode;
        this.oldDocument = oldDocument;
        this.isJunk = isJunk;
    }

    public void setOldDocument(String oldDocument) {
        this.oldDocument = oldDocument;
    }

    public void setNewDocument(String newDocument) {
        this.newDocument = newDocument;
    }

    public List<Change> getDiff() {
        if (this.diff.isEmpty()) {
            this.diff = this.createDiff(new SequenceMatcher(this.newNode, this.oldNode, this.isJunk));
        }
        return this.diff;
    }

    public List<DeepDiff> getDeepDiff() {
        if (this.deepdiff.isEmpty()) {
            if (this.oldDocument == null || this.newDocument == null) {
                throw new NullPointerException();
            }
            this.deepdiff = this.createDeepDiff(this.createDiff(new SequenceMatcher(this.newNode, this.oldNode, this.isJunk)));
        }
        return this.deepdiff;
    }

    protected List<Change> createDiff(SequenceMatcher sequenceMatch) {
        return sequenceMatch.getDiffNodes();
    }

    protected List<DeepDiff> createDeepDiff(List<Change> roughDiff) {
        ArrayList<DeepDiff> complexDiff = new ArrayList<DeepDiff>();
        for (Change change : roughDiff) {
            complexDiff.add(new DeepDiff(change, this.getSubdiff(change)));
        }
        return complexDiff;
    }

    protected List<Change> getSubdiff(Change change) {
        Node oNode = change.getOldNode();
        Node nNode = change.getNewNode();
        if (oNode == null || nNode == null || !(oNode instanceof ILocalScope) || oNode instanceof RootNode) {
            return null;
        }
        return this.sortSubdiff(new SequenceMatcher(nNode, oNode).getDiffNodes());
    }

    protected List<Change> sortSubdiff(List<Change> subdiff) {
        ArrayList<Change> diffClone = new ArrayList<Change>(subdiff);
        for (Change change : diffClone) {
            if (change.getOldNode() == null) continue;
            Node oNode = change.getOldNode();
            for (Change newChange : diffClone) {
                String ostring;
                String nstring;
                int lfd;
                double ratio;
                if (newChange.getNewNode() == null) continue;
                Node nNode = newChange.getNewNode();
                if (subdiff.indexOf(change) == subdiff.indexOf(newChange) || !((ratio = (double)(lfd = NodeDiff.distance(nstring = ReWriteVisitor.createCodeFromNode(nNode, this.newDocument), ostring = ReWriteVisitor.createCodeFromNode(oNode, this.oldDocument))) / (double)Math.max(nstring.length(), ostring.length())) < 0.2) || !subdiff.contains(change)) continue;
                SequenceMatcher sm = new SequenceMatcher(null, null, null);
                subdiff.set(subdiff.indexOf(change), new Change(nNode, sm.calcComplexity(nNode), oNode, sm.calcComplexity(oNode)));
                subdiff.remove(newChange);
            }
        }
        return subdiff;
    }

    private static int distance(String s1, String s2) {
        int i;
        int[][] edits = new int[s1.length() + 1][s2.length() + 1];
        for (i = 0; i <= s1.length(); ++i) {
            edits[i][0] = i;
        }
        for (int j = 1; j <= s2.length(); ++j) {
            edits[0][j] = j;
        }
        for (i = 1; i <= s1.length(); ++i) {
            for (int j = 1; j <= s2.length(); ++j) {
                int u = s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1;
                edits[i][j] = Math.min(edits[i - 1][j] + 1, Math.min(edits[i][j - 1] + 1, edits[i - 1][j - 1] + u));
            }
        }
        return edits[s1.length()][s2.length()];
    }
}

