/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.coffeescript.highlighter.CoffeeScriptSyntaxHighlighter;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptKeywordHighlighterVisitor
extends JSKeywordHighlighterVisitor {
    private final TokenSet OPERATOR_KEYWORDS;
    private final TokenSet KEYWORD_TOKENS;

    public CoffeeScriptKeywordHighlighterVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            CoffeeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        super(holder, (JSHighlighter)new CoffeeScriptSyntaxHighlighter());
        this.OPERATOR_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.ANDAND, JSTokenTypes.OROR, JSTokenTypes.EXCL, CoffeeScriptTokenTypes.EQ_EQ_EQ, CoffeeScriptTokenTypes.NOT_EQ_EQ, JSTokenTypes.OR_OR_EQ, JSTokenTypes.AND_AND_EQ});
        this.KEYWORD_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FROM_KEYWORD});
    }

    public void visitES6FromClause(ES6FromClause element) {
        this.highlightChildKeywordOfTypes((PsiElement)element, this.KEYWORD_TOKENS);
        super.visitES6FromClause(element);
    }

    public void visitJSForStatement(JSForStatement node) {
        this.highlightChildKeywordOfTypes((PsiElement)node, this.KEYWORD_TOKENS);
        super.visitJSForStatement(node);
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        this.highlightChildKeywordOfTypes((PsiElement)node, this.OPERATOR_KEYWORDS);
        super.visitJSBinaryExpression(node);
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        this.highlightChildKeywordOfTypes((PsiElement)node, this.OPERATOR_KEYWORDS);
        super.visitJSPrefixExpression(node);
    }

    protected void highlightChildKeywordOfTypes(@NotNull PsiElement parent, @NotNull TokenSet types) {
        CharSequence cs;
        ASTNode keyword;
        if (parent == null) {
            CoffeeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        if (types == null) {
            CoffeeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        if ((keyword = parent.getNode().findChildByType(types)) != null && (cs = keyword.getChars()).length() > 0 && Character.isAlphabetic(cs.charAt(0))) {
            CoffeeScriptKeywordHighlighterVisitor.highlightKeyword((ASTNode)keyword, (AnnotationHolder)this.myHolder, (JSHighlighter)this.myHighlighter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/highlighter/CoffeeScriptKeywordHighlighterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

