/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.markdown4j.Markdown4jProcessor;

public class PhpDocMarkdownUtil {
    private static final String HTML_CODE_START = "<code>";
    private static final String HTML_CODE_END = "</code>";
    private static final String FENCED_CODE_BLOCK = "```";
    private static final String INLINE_CODE_BLOCK = "``";
    private static final Markdown4jProcessor ourMarkdownProcessor = new Markdown4jProcessor();
    private static final Map<String, String> HTML_DOC_SUBSTITUTIONS = new HashMap();

    private PhpDocMarkdownUtil() {
    }

    @NotNull
    static String markdown2Html(String description) {
        String html;
        ArrayList lines = ContainerUtil.newArrayList((Object[])description.split("\n|\r|\r\n"));
        ArrayList<String> processedLines = new ArrayList<String>();
        boolean isInCode = false;
        for (String line : lines) {
            String processedLine = StringUtil.trimTrailing((String)line);
            if ((processedLine = StringUtil.trimStart((String)processedLine, (String)" ")).contains(FENCED_CODE_BLOCK)) {
                isInCode = !isInCode;
            } else if (isInCode) {
                if (processedLine.startsWith(HTML_CODE_END)) {
                    processedLines.add(FENCED_CODE_BLOCK);
                    processedLine = StringUtil.trimStart((String)processedLine, (String)HTML_CODE_END);
                    isInCode = false;
                }
            } else {
                boolean codeStart = false;
                if (processedLine.endsWith(HTML_CODE_START)) {
                    codeStart = true;
                    processedLine = StringUtil.trimEnd((String)processedLine, (String)HTML_CODE_START);
                }
                processedLine = processedLine.replace("<pre>", FENCED_CODE_BLOCK).replace("</pre>", FENCED_CODE_BLOCK).replace(HTML_CODE_START, INLINE_CODE_BLOCK).replace(HTML_CODE_END, INLINE_CODE_BLOCK);
                if (codeStart) {
                    processedLines.add(processedLine);
                    processedLine = FENCED_CODE_BLOCK;
                    isInCode = true;
                }
            }
            processedLines.add(processedLine);
        }
        String normalizedMarkdown = StringUtil.join(processedLines, (String)"\n");
        try {
            html = ourMarkdownProcessor.process(normalizedMarkdown);
        }
        catch (IOException e) {
            if ("" == null) {
                PhpDocMarkdownUtil.$$$reportNull$$$0(0);
            }
            return "";
        }
        String string = PhpDocMarkdownUtil.adjustHtml(html);
        if (string == null) {
            PhpDocMarkdownUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String adjustHtml(@NotNull String html) {
        if (html == null) {
            PhpDocMarkdownUtil.$$$reportNull$$$0(2);
        }
        String str = html;
        for (String key : HTML_DOC_SUBSTITUTIONS.keySet()) {
            str = str.replace(key, HTML_DOC_SUBSTITUTIONS.get(key));
        }
        String string = str.trim();
        if (string == null) {
            PhpDocMarkdownUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    static {
        HTML_DOC_SUBSTITUTIONS.put("<pre><code>", "<pre>");
        HTML_DOC_SUBSTITUTIONS.put("</code></pre>", "</pre>");
        HTML_DOC_SUBSTITUTIONS.put("<em>", "<i>");
        HTML_DOC_SUBSTITUTIONS.put("</em>", "</i>");
        HTML_DOC_SUBSTITUTIONS.put("<strong>", "<b>");
        HTML_DOC_SUBSTITUTIONS.put("</strong>", "</b>");
        HTML_DOC_SUBSTITUTIONS.put(": //", "://");
        HTML_DOC_SUBSTITUTIONS.put("<br  />", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocMarkdownUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "markdown2Html";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocMarkdownUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustHtml";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

