/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIllegalArrayKeyTypeInspection
extends PhpInspection {
    private static final String ERROR = PhpBundle.message("inspection.illegal.array.key.type.problem", new Object[0]);
    private static final PhpType PRIMITIVE_TYPE_SET = new PhpType().add(PhpType.STRING).add(PhpType.INT).add(PhpType.MIXED).add(PhpType.NULL).add(PhpType.BOOLEAN).add(PhpType.NUMBER);
    private static final PhpType SPL = new PhpType().add("\\SplObjectStorage");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                IElementType elementType = element.getNode().getElementType();
                if (elementType == PhpElementTypes.ARRAY_KEY || elementType == PhpElementTypes.ARRAY_INDEX) {
                    PhpIllegalArrayKeyTypeInspection.analyzeElement(element.getFirstPsiChild(), holder);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void analyzeElement(@Nullable PhpPsiElement firstPsiChild, ProblemsHolder holder) {
        PhpType keyType;
        if (!(!(firstPsiChild instanceof PhpTypedElement) || (keyType = ((PhpTypedElement)firstPsiChild).getType().global(firstPsiChild.getProject()).filterUnknown()).isUndefined() || keyType.isEmpty() || PhpType.intersects((PhpType)keyType, (PhpType)PRIMITIVE_TYPE_SET) || PhpIllegalArrayKeyTypeInspection.isSplObjectStorage(firstPsiChild.getParent()))) {
            holder.registerProblem((PsiElement)firstPsiChild, holder.isOnTheFly() ? ERROR + " " + keyType.toStringRelativized("\\") : ERROR, new LocalQuickFix[0]);
        }
    }

    private static boolean isSplObjectStorage(@NotNull PsiElement arrayKey) {
        PhpType arrayType;
        PhpReference arrayReference;
        if (arrayKey == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(2);
        }
        if ((arrayReference = (PhpReference)PhpPsiUtil.getChildByCondition(arrayKey.getParent(), (Condition<? super PsiElement>)PhpReference.INSTANCEOF)) != null && !PhpType.intersects((PhpType)PhpType.ARRAY, (PhpType)(arrayType = arrayReference.getType()))) {
            return SPL.isConvertibleFrom(arrayType, PhpIndex.getInstance((Project)arrayReference.getProject()));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpIllegalArrayKeyTypeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIllegalArrayKeyTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSplObjectStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

