/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.function;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class InlineInputData {
    private PhpExpression myClassReference;
    private PhpClass parentClass;
    @NotNull
    public final Function myFunction;
    public final FunctionReference myFunctionReference;
    public final PsiElement[] parameterExpressions;

    public InlineInputData(FunctionReference reference, @NotNull Function function) {
        if (function == null) {
            InlineInputData.$$$reportNull$$$0(0);
        }
        this.myFunction = function;
        Project project = this.myFunction.getProject();
        this.myFunctionReference = reference;
        PsiElement[] functionReferenceParameters = this.myFunctionReference.getParameters();
        Parameter[] parameters = function.getParameters();
        if (parameters.length > 0 && parameters[parameters.length - 1].isVariadic()) {
            PsiElement arrayExpression = InlineInputData.constructArray(project, Arrays.copyOfRange(functionReferenceParameters, parameters.length - 1, functionReferenceParameters.length));
            this.parameterExpressions = (PsiElement[])ArrayUtil.mergeArrays((Object[])Arrays.copyOfRange(functionReferenceParameters, 0, parameters.length - 1), (Object[])new PsiElement[]{arrayExpression});
        } else {
            this.parameterExpressions = functionReferenceParameters;
        }
        if (reference instanceof MethodReference) {
            PsiElement resolve;
            this.myClassReference = ((MethodReference)this.myFunctionReference).getClassReference();
            if (this.myClassReference instanceof ClassReference && (resolve = ((ClassReference)this.myClassReference).resolve()) instanceof PhpClass) {
                PhpClass aClass = (PhpClass)resolve;
                this.parentClass = aClass.getSuperClass();
            }
        }
    }

    private static PsiElement constructArray(Project project, PsiElement[] elements) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, ArrayCreationExpression.class, "[" + StringUtil.join((Object[])elements, e -> e.getText(), (String)",") + "]");
    }

    public PhpExpression getClassReference() {
        return this.myClassReference;
    }

    public PhpClass getParentClass() {
        return this.parentClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/php/refactoring/inline/function/InlineInputData", "<init>"));
    }
}

