/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.run.PhpTestRunConfiguration;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkComposerConfig
extends PackageComposerConfigClient {
    private final PhpTestFrameworkType myFrameworkType;

    public PhpTestFrameworkComposerConfig(@NotNull PhpTestFrameworkType frameworkType, @NotNull String frameworkPackage, @NotNull String relativePath) {
        if (frameworkType == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(0);
        }
        if (frameworkPackage == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(1);
        }
        if (relativePath == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(2);
        }
        super(frameworkPackage, relativePath);
        this.myFrameworkType = frameworkType;
    }

    @Override
    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        PhpTestFrameworkConfiguration configuration;
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(3);
        }
        if ((configuration = PhpTestFrameworkSettingsManager.getInstance(project).getConfigByInterpreter(this.myFrameworkType, interpreter)) == null || StringUtil.isEmpty((String)configuration.getExecutablePath())) {
            String executable = this.findFromComposerVendor(project);
            if (StringUtil.isEmpty((String)executable) || !FileUtil.exists((String)executable)) {
                return;
            }
            PhpTestFrameworkConfiguration newConfig = PhpTestFrameworkSettingsManager.getInstance(project).getOrCreateByInterpreter(this.myFrameworkType, interpreter);
            newConfig.setExecutablePath(interpreter == null || !interpreter.isRemote() ? PathUtil.toSystemDependentName((String)executable) : executable);
            this.updateRunConfigurations(project, newConfig);
            this.notify(project, newConfig);
        }
    }

    protected void updateRunConfigurations(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration configuration) {
        VirtualFile file;
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(5);
        }
        if ((file = VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])new String[]{FileUtil.toCanonicalPath((String)this.getDefaultConfigName())})) == null) {
            file = VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])new String[]{FileUtil.toCanonicalPath((String)(this.getDefaultConfigName() + ".dist"))});
        }
        if (file == null) {
            return;
        }
        configuration.setUseConfigurationFile(true);
        configuration.setConfigurationFilePath(file.getPath());
        ConfigurationFactory[] factories = this.getConfigurationType().getConfigurationFactories();
        if (factories == null || factories.length != 1) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(file.getName(), factories[0]);
        PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)((PhpTestRunConfiguration)settings.getConfiguration()).getSettings()).getRunnerSettings();
        testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.ConfigurationFile);
        runManager.addConfiguration(settings);
    }

    @NotNull
    protected abstract String getDefaultConfigName();

    @NotNull
    protected abstract ConfigurationType getConfigurationType();

    protected void notify(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration newConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(6);
        }
        if (newConfig == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(7);
        }
        this.notify(project, newConfig.getFrameworkType().getDisplayName(), ComposerLogMessageBuilder.Settings.TEST_FRAMEWORKS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfig";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkComposerConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRunConfigurations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

