/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StyleCreator {
    public static final Key<StyleCreator> EXPLICITLY_CHOSEN_STYLE_CREATOR = new Key("EXPLICITLY_CHOSEN_STYLE_CREATOR");
    @NotNull
    private final String myName;
    @NotNull
    protected final PsiFile myContextFile;

    protected StyleCreator(@NotNull String name, @NotNull PsiFile contextFile) {
        if (name == null) {
            StyleCreator.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            StyleCreator.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myContextFile = contextFile;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            StyleCreator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected static CssRuleset createStyleInCssFile(@NotNull StylesheetFile file, @NotNull String selector, CssDeclaration ... declarations) {
        if (file == null) {
            StyleCreator.$$$reportNull$$$0(3);
        }
        if (selector == null) {
            StyleCreator.$$$reportNull$$$0(4);
        }
        if (declarations == null) {
            StyleCreator.$$$reportNull$$$0(5);
        }
        CssRuleset newRuleset = CssElementFactory.getInstance((Project)file.getProject()).createRuleset(selector, declarations, file.getLanguage());
        return StyleCreator.createStyleInCssFile(file, newRuleset);
    }

    @Nullable
    protected static CssRuleset createStyleInCssFile(@NotNull StylesheetFile file, @NotNull CssRuleset newRuleset) {
        if (file == null) {
            StyleCreator.$$$reportNull$$$0(6);
        }
        if (newRuleset == null) {
            StyleCreator.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!FileModificationService.getInstance().prepareFileForWrite((PsiFile)file)) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        CssStylesheet stylesheet = file.getStylesheet();
        if (stylesheet == null) {
            stylesheet = CssElementFactory.getInstance((Project)file.getProject()).createStylesheet("", file.getLanguage());
            stylesheet = (CssStylesheet)file.add((PsiElement)stylesheet);
        }
        if (stylesheet != null) {
            CssRuleset result = stylesheet.addRuleset(newRuleset);
            if (result != null) {
                CodeEditUtil.markToReformat((ASTNode)result.getNode(), (boolean)true);
            }
            return StyleCreator.postProcessAndRestoreElement(result);
        }
        return null;
    }

    @Nullable
    public abstract CssRuleset createStyleDeclaration(@NotNull String var1, CssDeclaration ... var2);

    @Nullable
    public CssRuleset createStyleDeclaration(@NotNull HtmlCssClassOrIdReference classOrIdReference, CssDeclaration ... declarations) {
        if (classOrIdReference == null) {
            StyleCreator.$$$reportNull$$$0(8);
        }
        if (declarations == null) {
            StyleCreator.$$$reportNull$$$0(9);
        }
        return this.createStyleDeclaration(StyleCreator.getSelectorForReference(classOrIdReference), declarations);
    }

    public abstract void createStyleDeclarationInteractively(@NotNull Editor var1, @NotNull String var2, @NotNull Collection<String> var3, @Nullable CreateStyleCallback var4, CssDeclaration ... var5);

    @NotNull
    private static String getSelectorForReference(@NotNull HtmlCssClassOrIdReference reference) {
        if (reference == null) {
            StyleCreator.$$$reportNull$$$0(10);
        }
        PsiElement referenceElement = reference.getElement();
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, XmlAttribute.class);
        assert (attribute != null);
        String string = ("id".equals(attribute.getName()) ? "#" : ".") + reference.getRangeInElement().substring(referenceElement.getText());
        if (string == null) {
            StyleCreator.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    protected static CssRuleset postProcessAndRestoreElement(@Nullable CssRuleset element) {
        if (element == null) {
            return null;
        }
        Project project = element.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile());
        if (document == null) {
            return null;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)element);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        return (CssRuleset)smartPsiElementPointer.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ruleset/StyleCreator";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRuleset";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrIdReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ruleset/StyleCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectorForReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStyleInCssFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createStyleDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectorForReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

