/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SelectTopOnConstArray {
    private final TLongArrayList myList;
    private final int myNumber;
    private final Processor<? super Integer> myFilter;
    private final Set<Integer> myExcludeSet;
    private final List<Pair<Long, Integer>> myIntermediate;
    private List<Pair<Long, Integer>> myTop;

    public SelectTopOnConstArray(TLongArrayList list, int number, Processor<? super Integer> filter) {
        this.myList = list;
        this.myNumber = number;
        this.myFilter = filter;
        this.myExcludeSet = new HashSet<Integer>();
        this.myIntermediate = new ArrayList<Pair<Long, Integer>>();
    }

    public void execute() {
        long max = this.findMax();
        this.findBound(max, this.myNumber);
        Collections.sort(this.myIntermediate, (o1, o2) -> ((Long)o2.getFirst()).compareTo((Long)o1.getFirst()));
        this.myTop = new ArrayList<Pair<Long, Integer>>(this.myIntermediate.subList(0, Math.min(this.myNumber, this.myIntermediate.size())));
    }

    public List<Pair<Long, Integer>> getTop() {
        return this.myTop;
    }

    private void findBound(long max, int number) {
        long lowerBound = max / 2L;
        long upperBound = max + 1L;
        int defense = 1000;
        while (number > 0 && defense-- > 0) {
            int cnt = this.countPercent(lowerBound, upperBound, number);
            if (cnt <= 3 * number) {
                this.gatherExceeding(lowerBound, upperBound);
                number -= cnt;
                upperBound = lowerBound;
                lowerBound /= 4L;
                continue;
            }
            lowerBound = (long)((double)lowerBound * 1.5);
        }
    }

    private void gatherExceeding(long greaterOrEqualTo, long lessThen) {
        for (int i = 0; i < this.myList.size(); ++i) {
            long value;
            if (this.excluded(i) || (value = this.myList.get(i)) < greaterOrEqualTo || value >= lessThen) continue;
            this.myIntermediate.add((Pair<Long, Integer>)Pair.create((Object)value, (Object)i));
        }
    }

    private int countPercent(long greaterOrEqualTo, long lessThen, int number) {
        int cnt = 0;
        for (int i = 0; i < this.myList.size() && cnt <= number; ++i) {
            long value;
            if (this.excluded(i) || (value = this.myList.get(i)) < greaterOrEqualTo || value >= lessThen) continue;
            ++cnt;
        }
        return cnt;
    }

    private long findMax() {
        long max = 0L;
        for (int i = 0; i < this.myList.size(); ++i) {
            long value;
            if (this.excluded(i) || (value = this.myList.get(i)) <= max) continue;
            max = value;
        }
        return max;
    }

    private boolean excluded(int i) {
        return !this.myFilter.process((Object)i) || this.myExcludeSet.contains(i);
    }
}

