/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.wordpress.hooks.WPHook;
import com.jetbrains.php.wordpress.hooks.WPHookName;
import com.jetbrains.php.wordpress.hooks.WPHookNamePart;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import com.jetbrains.php.wordpress.hooks.WPHookUtils;
import com.jetbrains.php.wordpress.hooks.WPHooksIndex;
import icons.WordPressIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPHooksSymbolContributor
implements ChooseByNameContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
        FileBasedIndex index = FileBasedIndex.getInstance();
        index.processAllKeys(WPHooksIndex.KEY, (Processor)processor, project);
        HashSet<String> hookNames = new HashSet<String>();
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
        for (WPHook hook : processor.getResults()) {
            Collection fileCollection = index.getContainingFiles(WPHooksIndex.KEY, (Object)hook, searchScope);
            if (fileCollection.isEmpty()) continue;
            hookNames.add(WPHooksSymbolContributor.createPresentation(hook.getName()));
        }
        String[] stringArray = ArrayUtil.toStringArray(hookNames);
        if (stringArray == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        MyHooksInvocationCollector collector = new MyHooksInvocationCollector(name);
        WPHookName hookName = WPHooksSymbolContributor.restoreNameFromPresentation(name);
        WPHook pureStringActionHook = new WPHook(hookName, WPHookType.ACTION);
        WPHook pureStringFilterHook = new WPHook(hookName, WPHookType.FILTER);
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        HashSet filesToProcess = new HashSet();
        filesToProcess.addAll(FileBasedIndex.getInstance().getContainingFiles(WPHooksIndex.KEY, (Object)pureStringActionHook, scope));
        filesToProcess.addAll(FileBasedIndex.getInstance().getContainingFiles(WPHooksIndex.KEY, (Object)pureStringFilterHook, scope));
        for (VirtualFile vFile : filesToProcess) {
            PsiFile file = PsiManager.getInstance((Project)project).findFile(vFile);
            if (file == null) continue;
            file.accept((PsiElementVisitor)collector);
        }
        NavigationItem[] navigationItemArray = (NavigationItem[])ArrayUtil.toObjectArray((Collection)collector.myInvocations, NavigationItem.class);
        if (navigationItemArray == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(1);
        }
        return navigationItemArray;
    }

    private static String createPresentation(WPHookName name) {
        String pureStringText = name.getPureStringText();
        if (pureStringText != null) {
            return pureStringText;
        }
        StringBuilder sb = new StringBuilder();
        for (WPHookNamePart part : name.getParts()) {
            if (part.isStringValue()) {
                sb.append(part.getText());
                continue;
            }
            sb.append('{').append(part.getText()).append('}');
        }
        return sb.toString();
    }

    private static WPHookName restoreNameFromPresentation(String presentation) {
        int beginningIndex = presentation.indexOf(123);
        if (beginningIndex == -1) {
            return new WPHookName(Collections.singletonList(new WPHookNamePart(presentation, true)));
        }
        ArrayList<WPHookNamePart> parts = new ArrayList<WPHookNamePart>();
        if (beginningIndex > 0) {
            parts.add(new WPHookNamePart(presentation.substring(0, beginningIndex), true));
        }
        int level = 1;
        for (int i = beginningIndex + 1; i < presentation.length(); ++i) {
            char c = presentation.charAt(i);
            if (c == '{') {
                if (++level != 1) continue;
                parts.add(new WPHookNamePart(presentation.substring(beginningIndex + 1, i), true));
                beginningIndex = i;
                continue;
            }
            if (c != '}' || --level != 0) continue;
            parts.add(new WPHookNamePart(presentation.substring(beginningIndex + 1, i), false));
            beginningIndex = i;
        }
        if (beginningIndex + 1 != presentation.length()) {
            parts.add(new WPHookNamePart(presentation.substring(beginningIndex + 1), level == 0));
        }
        return new WPHookName(parts);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/wordpress/hooks/WPHooksSymbolContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class WPHookNavigatable
    implements PsiElementNavigationItem {
        private final FunctionReference myInvocation;
        private final String myName;

        private WPHookNavigatable(@NotNull String name, @NotNull FunctionReference invocation) {
            if (name == null) {
                WPHookNavigatable.$$$reportNull$$$0(0);
            }
            if (invocation == null) {
                WPHookNavigatable.$$$reportNull$$$0(1);
            }
            this.myInvocation = invocation;
            this.myName = name;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            ItemPresentation itemPresentation = new ItemPresentation(){

                @Nullable
                public String getPresentableText() {
                    return myName;
                }

                @Nullable
                public String getLocationString() {
                    PsiFile containingFile = myInvocation.getContainingFile();
                    return containingFile != null ? containingFile.getName() : null;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return WordPressIcons.HookElement;
                }
            };
            if (itemPresentation == null) {
                WPHookNavigatable.$$$reportNull$$$0(2);
            }
            return itemPresentation;
        }

        public void navigate(boolean requestFocus) {
            this.myInvocation.navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.myInvocation.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.myInvocation.canNavigateToSource();
        }

        @Nullable
        public PsiElement getTargetElement() {
            return this.myInvocation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WPHookNavigatable that = (WPHookNavigatable)o;
            if (!this.myInvocation.equals(that.myInvocation)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myInvocation.hashCode();
            result = 31 * result + this.myName.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHooksSymbolContributor$WPHookNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHooksSymbolContributor$WPHookNavigatable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyHooksInvocationCollector
    extends PhpRecursiveElementVisitor {
        private final List<NavigationItem> myInvocations = new ArrayList<NavigationItem>();
        private final String myHookName;

        private MyHooksInvocationCollector(String hookName) {
            this.myHookName = hookName;
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            super.visitPhpFunctionCall(reference);
            String functionName = reference.getName();
            WPHookType type = WPHookType.findByInvocationMethod(functionName);
            if (type == null) {
                return;
            }
            WPHookName hookName = WPHookUtils.getHookNameFromInvocation(reference, false);
            if (hookName != null && this.myHookName.equals(WPHooksSymbolContributor.createPresentation(hookName))) {
                this.myInvocations.add((NavigationItem)new WPHookNavigatable(this.myHookName, reference));
            }
        }
    }
}

