/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellRenderers
implements Disposable {
    public final DataGrid grid;
    private final Ref<Map<GridCellRendererFactory, GridCellRenderer>> myCreatedRenderers;

    public GridCellRenderers(@NotNull DataGrid grid) {
        if (grid == null) {
            GridCellRenderers.$$$reportNull$$$0(0);
        }
        this.myCreatedRenderers = Ref.create((Object)ContainerUtil.newIdentityTroveMap());
        this.grid = grid;
    }

    @Nullable
    public GridCellRenderer getRenderer(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            GridCellRenderers.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellRenderers.$$$reportNull$$$0(2);
        }
        if (this.myCreatedRenderers.isNull()) {
            return null;
        }
        DataConsumer.Column c2 = this.grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column2);
        if (c2 == null) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this.grid);
        GridCellRenderer bestRenderer = null;
        int bestSuitability = 0;
        for (GridCellRendererFactory factory : GridCellRendererFactories.getInstance().getFactoriesFor(dialect, c2)) {
            GridCellRenderer renderer = this.getOrCreateRenderer(factory);
            int suitability = renderer.getSuitability(row, column2);
            if (suitability <= bestSuitability) continue;
            bestRenderer = renderer;
            bestSuitability = suitability;
        }
        return bestRenderer;
    }

    public void dispose() {
        this.myCreatedRenderers.set(null);
    }

    private GridCellRenderer getOrCreateRenderer(GridCellRendererFactory factory) {
        Map createdRenderers = (Map)this.myCreatedRenderers.get();
        GridCellRenderer renderer = (GridCellRenderer)createdRenderers.get(factory);
        if (renderer == null) {
            renderer = factory.createRenderer(this.grid);
            Disposer.register((Disposable)this, (Disposable)renderer);
            createdRenderers.put(factory, renderer);
        }
        return renderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/GridCellRenderers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

