/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlIdentifier;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLiteral;
import com.intellij.sql.formatter.model.SqlRootBlock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"adjustEnclosingBlocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "blocks", "findEnclosingBlocks", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "offset", "", "getLineIndentInsideLeaf", "", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "intellij.database.sql.impl"})
public final class SqlLineIndentProviderKt {
    private static final String getLineIndentInsideLeaf(SqlLeafBlock block) {
        SqlLeafBlock sqlLeafBlock = block;
        return sqlLeafBlock instanceof SqlLiteral ? "" : (sqlLeafBlock instanceof SqlIdentifier ? (((SqlIdentifier)block).getQuoted() ? "" : LineIndentProvider.DO_NOT_ADJUST) : LineIndentProvider.DO_NOT_ADJUST);
    }

    /*
     * WARNING - void declaration
     */
    private static final AdjacentBlocks findEnclosingBlocks(SqlBlock block, int offset) {
        if (block instanceof SqlRootBlock) {
            return SqlLineIndentProviderKt.findEnclosingBlocks(((SqlRootBlock)block).getNestedBlock(), offset);
        }
        TextRange r = block.getRange();
        if (offset <= r.getStartOffset()) {
            return new AdjacentBlocks(null, block);
        }
        if (offset >= r.getEndOffset()) {
            return new AdjacentBlocks(block, null);
        }
        if (block instanceof SqlLeafBlock) {
            return new AdjacentBlocks(block, block);
        }
        List<SqlBlock> children2 = block.getSubBlocks();
        int n = children2.size();
        if (n == 0) {
            return new AdjacentBlocks(block, block);
        }
        SqlBlock b0 = children2.get(0);
        TextRange r0 = b0.getRange();
        if (offset <= r0.getStartOffset()) {
            return new AdjacentBlocks(null, b0);
        }
        if (offset < r0.getEndOffset()) {
            return SqlLineIndentProviderKt.findEnclosingBlocks(b0, offset);
        }
        int n2 = 1;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            SqlBlock b2 = children2.get((int)i2);
            TextRange r2 = b2.getRange();
            if (offset <= r2.getStartOffset()) {
                return new AdjacentBlocks(children2.get((int)(i2 - true)), b2);
            }
            if (offset < r2.getEndOffset()) {
                return SqlLineIndentProviderKt.findEnclosingBlocks(b2, offset);
            }
            ++i2;
        }
        if (offset < block.getRange().getEndOffset()) {
            return new AdjacentBlocks((SqlBlock)CollectionsKt.last(children2), null);
        }
        return new AdjacentBlocks(block, block);
    }

    private static final AdjacentBlocks adjustEnclosingBlocks(AdjacentBlocks blocks) {
        Collection collection;
        SqlBlock sqlBlock = blocks.getBlock1();
        if (sqlBlock == null) {
            return blocks;
        }
        SqlBlock b1 = sqlBlock;
        if (!b1.incomplete()) {
            return blocks;
        }
        while (b1 instanceof SqlFlowBlock && !(collection = (Collection)((SqlFlowBlock)b1).getSubBlocks()).isEmpty() && b1.incomplete()) {
            b1 = (SqlBlock)CollectionsKt.last(((SqlFlowBlock)b1).getSubBlocks());
        }
        return new AdjacentBlocks(b1, null);
    }

    @NotNull
    public static final /* synthetic */ AdjacentBlocks access$adjustEnclosingBlocks(@NotNull AdjacentBlocks blocks) {
        return SqlLineIndentProviderKt.adjustEnclosingBlocks(blocks);
    }

    @NotNull
    public static final /* synthetic */ AdjacentBlocks access$findEnclosingBlocks(@NotNull SqlBlock block, int offset) {
        return SqlLineIndentProviderKt.findEnclosingBlocks(block, offset);
    }

    @Nullable
    public static final /* synthetic */ String access$getLineIndentInsideLeaf(@NotNull SqlLeafBlock block) {
        return SqlLineIndentProviderKt.getLineIndentInsideLeaf(block);
    }
}

