/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerAuthConfigImpl;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRegistry
extends CloudConfigurationBase<DockerRegistry> {
    @Deprecated
    public static final String DOCKER_HUB_ADDRESS = "registry.hub.docker.com";
    public static final String[] PROVIDER_ADDRESSES = new String[]{"quay.io"};
    private String myName;
    private String myAddress;
    private String myUsername;

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public DockerRegistry withName(String name) {
        this.setName(name);
        return this;
    }

    public String getAddress() {
        return this.myAddress;
    }

    public void setAddress(String address) {
        this.myAddress = address;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public DockerAuthConfig getAuthConfig() {
        DockerAuthConfigImpl result = new DockerAuthConfigImpl();
        result.setServerAddress(this.myAddress);
        result.setUsername(this.myUsername);
        result.setPassword(this.getPasswordSafe());
        result.setEmail(this.getEmail());
        return result;
    }

    public boolean isDockerHub() {
        return StringUtil.equals((CharSequence)this.myAddress, (CharSequence)DOCKER_HUB_ADDRESS);
    }

    public boolean hasUserData() {
        return StringUtil.isNotEmpty((String)this.getUsername());
    }

    @Nullable
    protected String getServiceName() {
        String name = this.getName();
        return StringUtil.isEmpty((String)name) ? null : "IntelliJ Platform Docker Registry - " + name;
    }

    protected String getCredentialUser() {
        return this.getUsername();
    }

    public boolean mayContainTag(@NotNull DockerRepoTag tag) {
        if (tag == null) {
            DockerRegistry.$$$reportNull$$$0(0);
        }
        return tag.isOwnedBy(this.getAddress(), this.getUsername());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/docker/registry/DockerRegistry", "mayContainTag"));
    }
}

