/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.parser;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BladeDirectiveStack {
    protected final Stack<DirectiveData> myData = new Stack();

    public void handleFile(@NotNull BladeFileImpl bladeFile) {
        if (bladeFile == null) {
            BladeDirectiveStack.$$$reportNull$$$0(0);
        }
        for (BladePsiDirective directive : bladeFile.getDirectives()) {
            this.pushDirective(directive);
        }
        this.cleanAndReportUnclosedDirectives();
    }

    public void pushDirective(BladePsiDirective directive) {
        DirectiveData data;
        if (directive.getDirectiveElementType() == BladeTokenTypes.SECTION_DIRECTIVE) {
            SmartList oldData = new SmartList();
            boolean foundPreviousSection = false;
            while (!this.myData.isEmpty()) {
                DirectiveData data2 = (DirectiveData)this.myData.pop();
                oldData.add(data2);
                if (data2.myDirective.getDirectiveElementType() != BladeTokenTypes.SECTION_DIRECTIVE) continue;
                foundPreviousSection = true;
                break;
            }
            if (foundPreviousSection) {
                for (DirectiveData datum : oldData) {
                    this.reportMissingClosingProblem(datum.myDirective);
                }
            } else {
                while (!oldData.isEmpty()) {
                    this.myData.push(oldData.remove(oldData.size() - 1));
                }
            }
            if (!BladeDirectiveStack.isInlinedSection(directive)) {
                this.myData.push((Object)new DirectiveData(directive));
            }
            return;
        }
        if (!this.myData.isEmpty() && (data = (DirectiveData)this.myData.peek()).tryToContinue(directive)) {
            return;
        }
        if (directive.isContinued() || directive.isToBeClosed()) {
            this.myData.push((Object)new DirectiveData(directive));
            if (directive.isContinuing()) {
                this.reportMissingOpeningProblem(directive);
            }
            return;
        }
        if (directive.isClosing()) {
            boolean missingOpening;
            if (this.myData.isEmpty()) {
                missingOpening = true;
            } else {
                boolean bl = missingOpening = !this.directiveClosesCurrentData(directive);
                if (!missingOpening) {
                    DirectiveData pop = (DirectiveData)this.myData.pop();
                    ArrayList<BladePsiDirective> directives = new ArrayList<BladePsiDirective>();
                    while (pop != null) {
                        directives.add(pop.myDirective);
                        pop = pop.childData;
                    }
                    directives.add(directive);
                    this.directiveClosed(directives);
                } else {
                    SmartList oldData = new SmartList();
                    while (!this.myData.isEmpty()) {
                        DirectiveData data3 = (DirectiveData)this.myData.pop();
                        if (directive.closes(data3.myDirective)) {
                            for (DirectiveData datum : oldData) {
                                this.reportMissingClosingProblem(datum.myDirective);
                            }
                            return;
                        }
                        oldData.add(data3);
                    }
                    while (!oldData.isEmpty()) {
                        this.myData.push(oldData.remove(oldData.size() - 1));
                    }
                }
            }
            if (missingOpening) {
                this.reportMissingOpeningProblem(directive);
            }
        }
    }

    protected void directiveClosed(@NotNull List<BladePsiDirective> directives) {
        if (directives == null) {
            BladeDirectiveStack.$$$reportNull$$$0(1);
        }
    }

    public static boolean isInlinedSection(BladePsiDirective directive) {
        if (directive.getDirectiveElementType() != BladeTokenTypes.SECTION_DIRECTIVE) {
            return false;
        }
        return directive.hasMultipleParameters();
    }

    public static boolean isInlinedPush(BladePsiDirective directive) {
        if (directive.getDirectiveElementType() != BladeTokenTypes.PUSH_DIRECTIVE) {
            return false;
        }
        return directive.hasMultipleParameters();
    }

    public static boolean isInlinedPrepend(BladePsiDirective directive) {
        if (directive.getDirectiveElementType() != BladeTokenTypes.PREPEND_DIRECTIVE) {
            return false;
        }
        return directive.hasMultipleParameters();
    }

    protected boolean directiveClosesCurrentData(BladePsiDirective directive) {
        DirectiveData data = (DirectiveData)this.myData.peek();
        return directive.closes(data.myDirective);
    }

    protected abstract void reportMissingOpeningProblem(BladePsiDirective var1);

    protected abstract void reportMissingClosingProblem(BladePsiDirective var1);

    public void cleanAndReportUnclosedDirectives() {
        while (!this.myData.empty()) {
            DirectiveData data = (DirectiveData)this.myData.pop();
            this.reportMissingClosingProblem(data.myDirective);
        }
    }

    public void handleDirectivesBeforeElement(PsiElement element) {
        int offset = element.getTextRange().getStartOffset();
        PsiFile file = element.getContainingFile();
        if (!(file instanceof BladeFileImpl)) {
            return;
        }
        BladeFileImpl bladeFile = (BladeFileImpl)file;
        for (BladePsiDirective directive : bladeFile.getDirectives()) {
            if (directive.getTextRange().getStartOffset() >= offset) break;
            this.pushDirective(directive);
        }
        this.cleanAndReportUnclosedDirectives();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bladeFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directives";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/parser/BladeDirectiveStack";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "directiveClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class DirectiveData {
        public final BladePsiDirective myDirective;
        DirectiveData childData;

        private DirectiveData(BladePsiDirective directive) {
            this.myDirective = directive;
        }

        public boolean tryToContinue(@NotNull BladePsiDirective directive) {
            if (directive == null) {
                DirectiveData.$$$reportNull$$$0(0);
            }
            if (this.childData != null) {
                return this.childData.tryToContinue(directive);
            }
            boolean continues = directive.continues(this.myDirective);
            if (continues) {
                this.childData = new DirectiveData(directive);
            }
            return continues;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "com/jetbrains/php/blade/parser/BladeDirectiveStack$DirectiveData", "tryToContinue"));
        }
    }
}

