/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;

public class TrippleStateCheckBox
extends JCheckBox {
    private boolean _undefined;
    private ArrayList<ActionListener> _listeners = new ArrayList();

    public TrippleStateCheckBox(String text) {
        super(text);
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrippleStateCheckBox.this.onAction(e);
            }
        });
    }

    private void onAction(ActionEvent e) {
        this._undefined = false;
        this.fireListeners(e);
    }

    private void fireListeners(ActionEvent e) {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this._listeners.toArray(new ActionListener[this._listeners.size()])) {
            listener.actionPerformed(e);
        }
    }

    public void setUndefined(boolean b) {
        if (this.isSelected()) {
            this._undefined = b;
        }
    }

    @Override
    public void addActionListener(ActionListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this._listeners.remove(l);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this._undefined) {
            return;
        }
        Dimension size = this.getSize();
        FontMetrics fontMetrics = g.getFontMetrics(this.getFont());
        int iconWidth = size.width - this.getIconTextGap() - fontMetrics.getStringBounds((String)this.getText(), (Graphics)g).getBounds().width - this.getInsets().right - this.getInsets().left;
        int iconHeight = size.height - this.getInsets().bottom - this.getInsets().top;
        int iconX = this.getInsets().left;
        int iconY = this.getInsets().top;
        int grid = 2;
        Color oldColor = g.getColor();
        g.setColor(Color.WHITE);
        for (int i = 0; i <= iconWidth + grid; i += 2 * grid) {
            for (int j = 0; j <= iconHeight + grid; j += 2 * grid) {
                g.fillRect(iconX + i, iconY + j, grid, grid);
            }
        }
        g.setColor(oldColor);
    }

    public boolean isUndefined() {
        return this._undefined;
    }
}

