/*
 * Decompiled with CFR 0.152.
 */
package org.fife.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.Sides;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.fife.ui.EscapableDialog;
import org.fife.ui.RScrollPane;
import org.fife.ui.StatusBar;
import org.fife.ui.UIUtil;

public class PrintPreviewDialog
extends EscapableDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private JPanel previewPanel;
    private PagePreview[] pageImage;
    private Printable masterImage;
    private JButton printButton;
    private JButton nextPageButton;
    private JButton prevPageButton;
    private JButton closeButton;
    private JComboBox sizeComboBox;
    private JComboBox numPagesComboBox;
    private int scale;
    private int pageWidth;
    private int pageHeight;
    private int currentPage;
    private int numVisiblePages;
    private int numPages;
    private Cursor zoomInCursor;
    private Cursor zoomOutCursor;
    private Border pagePreviewBorder;
    private PageFormat pageFormat;
    private static final int MAX_PAGE_COUNT = 4;

    public PrintPreviewDialog(Frame owner, Printable printable) {
        super(owner);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.print.PrintPreviewDialog");
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        this.pageFormat = prnJob.defaultPage();
        this.createCursors();
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new GridLayout(1, 6, 5, 10));
        Box topPanel = new Box(2);
        topPanel.add(toolBarPanel);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 2, 1));
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.add((Component)topPanel, "North");
        contentPane.add((Component)new StatusBar(""), "South");
        this.printButton = new JButton(msg.getString("Print"));
        this.printButton.setActionCommand("Print");
        this.printButton.addActionListener(this);
        toolBarPanel.add(this.printButton);
        this.prevPageButton = new JButton(msg.getString("PrevPage"));
        this.prevPageButton.setEnabled(false);
        this.prevPageButton.setActionCommand("PrevPage");
        this.prevPageButton.addActionListener(this);
        toolBarPanel.add(this.prevPageButton);
        this.nextPageButton = new JButton(msg.getString("NextPage"));
        this.nextPageButton.setActionCommand("NextPage");
        this.nextPageButton.addActionListener(this);
        toolBarPanel.add(this.nextPageButton);
        this.closeButton = new JButton(msg.getString("Close"));
        this.closeButton.setActionCommand("Close");
        this.closeButton.addActionListener(this);
        toolBarPanel.add(this.closeButton);
        this.sizeComboBox = new JComboBox<String>(new String[]{"10%", "25%", "33%", "50%", "66%", "75%", "100%", "150%", "200%"});
        UIUtil.fixComboOrientation(this.sizeComboBox);
        this.sizeComboBox.addItemListener(this);
        toolBarPanel.add(this.sizeComboBox);
        this.numPagesComboBox = new JComboBox<String>(new String[]{"1", "2", "3", "4"});
        UIUtil.fixComboOrientation(this.numPagesComboBox);
        this.numPagesComboBox.addItemListener(this);
        toolBarPanel.add(this.numPagesComboBox);
        toolBarPanel.add(Box.createHorizontalGlue());
        this.previewPanel = new JPanel();
        this.previewPanel.setBackground(Color.GRAY);
        RScrollPane scrollPane = new RScrollPane(this.previewPanel);
        contentPane.add(scrollPane);
        this.masterImage = printable;
        this.scale = 25;
        this.sizeComboBox.setSelectedItem("25%");
        this.pageImage = new PagePreview[4];
        this.setNumVisiblePages(1);
        this.setPreviewPage(0);
        this.setModal(true);
        JDialog dummyDialog = new JDialog();
        dummyDialog.pack();
        Graphics h = dummyDialog.getGraphics();
        this.numPages = 0;
        try {
            while (printable.print(h, this.pageFormat, this.numPages) == 0) {
                ++this.numPages;
            }
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
        }
        h.dispose();
        this.updateButtons();
        this.setTitle(msg.getString("Title"));
        this.applyComponentOrientation(orientation);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Close")) {
            this.setVisible(false);
        } else {
            if (actionCommand.equals("NextPage")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.incrementPreviewPage();
                }
                finally {
                    this.updateButtons();
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (actionCommand.equals("PrevPage")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.decrementPreviewPage();
                }
                finally {
                    this.updateButtons();
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (actionCommand.equals("Print")) {
                DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
                attributeSet.add(new Copies(1));
                attributeSet.add(Sides.ONE_SIDED);
                attributeSet.add(OrientationRequested.PORTRAIT);
                PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
                PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
                PrintService chosenService = ServiceUI.printDialog(null, 200, 200, services, defaultService, flavor, attributeSet);
                if (chosenService != null) {
                    DocPrintJob job = chosenService.createPrintJob();
                    SimpleDoc myDoc = new SimpleDoc(this.masterImage, flavor, null);
                    try {
                        job.print(myDoc, attributeSet);
                    }
                    catch (PrintException pe) {
                        JOptionPane.showMessageDialog(this, "Error attempting to print: " + pe + ".", "Printing Error", 0);
                    }
                }
                this.setVisible(false);
            }
        }
    }

    private void createCursors() {
        BufferedImage zoomInCursor1 = null;
        BufferedImage zoomOutCursor1 = null;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            zoomInCursor1 = ImageIO.read(cl.getResource("org/fife/print/zoomin.gif"));
            zoomOutCursor1 = ImageIO.read(cl.getResource("org/fife/print/zoomout.gif"));
        }
        catch (Exception e) {
            Cursor defaultCursor;
            e.printStackTrace();
            this.zoomInCursor = defaultCursor = Cursor.getPredefinedCursor(0);
            this.zoomOutCursor = defaultCursor;
            return;
        }
        Point hotspot = new Point(0, 0);
        this.zoomInCursor = PrintPreviewDialog.getCustomCursor(zoomInCursor1, hotspot, "ZoomInCursor", 32, 32);
        this.zoomOutCursor = PrintPreviewDialog.getCustomCursor(zoomOutCursor1, hotspot, "ZoomOutCursor", 32, 32);
    }

    public void decrementPreviewPage() {
        if (this.pageImage == null || this.currentPage == 0) {
            return;
        }
        --this.currentPage;
        PagePreview pp = null;
        pp = this.pageImage[this.numVisiblePages - 1];
        this.previewPanel.remove(pp);
        for (int i = this.numVisiblePages - 1; i > 0; --i) {
            this.pageImage[i] = this.pageImage[i - 1];
        }
        this.pageImage[0] = null;
        this.pageWidth = (int)this.pageFormat.getWidth();
        this.pageHeight = (int)this.pageFormat.getHeight();
        try {
            BufferedImage tempImage = pp.getSourceImage();
            Graphics g = tempImage.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.pageWidth, this.pageHeight);
            if (this.masterImage.print(g, this.pageFormat, this.currentPage) == 0) {
                int w = (int)((double)(this.pageWidth * this.scale) / 100.0);
                int h = (int)((double)(this.pageHeight * this.scale) / 100.0);
                pp.setScaledSize(w, h);
                this.pageImage[0] = pp;
                this.previewPanel.add((Component)pp, 0);
            } else {
                this.pageImage[0] = null;
            }
            g.dispose();
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
        }
        this.previewPanel.revalidate();
        this.previewPanel.repaint();
    }

    public final String getCloseButtonText() {
        return this.closeButton.getText();
    }

    private final Cursor getCursorForScale(int scale) {
        return scale >= 100 ? this.zoomOutCursor : this.zoomInCursor;
    }

    private static final Cursor getCustomCursor(Image image, Point hotspot, String name, int preferredWidth, int preferredHeight) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension bestCursorSize = toolkit.getBestCursorSize(preferredWidth, preferredHeight);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (bestCursorSize.width == width && bestCursorSize.height == height) {
            return toolkit.createCustomCursor(image, hotspot, name);
        }
        BufferedImage cursorImage = new BufferedImage(bestCursorSize.width, bestCursorSize.height, 2);
        Graphics2D g2d = cursorImage.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        return toolkit.createCustomCursor(cursorImage, hotspot, name);
    }

    public final String getNextPageButtonText() {
        return this.nextPageButton.getText();
    }

    private final synchronized Border getPagePreviewBorder() {
        if (this.pagePreviewBorder == null) {
            this.pagePreviewBorder = new MatteBorder(1, 1, 2, 2, Color.BLACK);
        }
        return this.pagePreviewBorder;
    }

    public final String getPrevPageButtonText() {
        return this.prevPageButton.getText();
    }

    public final String getPrintButtonText() {
        return this.printButton.getText();
    }

    public void incrementPreviewPage() {
        if (this.pageImage == null || this.currentPage == this.numPages - this.numVisiblePages) {
            return;
        }
        ++this.currentPage;
        PagePreview pp = this.pageImage[0];
        this.previewPanel.remove(pp);
        for (int i = 0; i < this.numVisiblePages - 1; ++i) {
            this.pageImage[i] = this.pageImage[i + 1];
        }
        this.pageWidth = (int)this.pageFormat.getWidth();
        this.pageHeight = (int)this.pageFormat.getHeight();
        try {
            BufferedImage tempImage = pp.getSourceImage();
            Graphics g = tempImage.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.pageWidth, this.pageHeight);
            if (this.masterImage.print(g, this.pageFormat, this.currentPage + this.numVisiblePages - 1) == 0) {
                int w = (int)((double)(this.pageWidth * this.scale) / 100.0);
                int h = (int)((double)(this.pageHeight * this.scale) / 100.0);
                pp.setScaledSize(w, h);
                this.pageImage[this.numVisiblePages - 1] = pp;
                this.previewPanel.add(pp);
            } else {
                this.pageImage[this.numVisiblePages - 1] = null;
            }
            g.dispose();
            this.previewPanel.revalidate();
            this.previewPanel.repaint();
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        JComboBox source = (JComboBox)e.getSource();
        if (e.getStateChange() == 1) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (source.equals(this.sizeComboBox)) {
                String choice = (String)e.getItem();
                choice = choice.substring(0, choice.length() - 1);
                this.scale = Integer.parseInt(choice);
                Cursor newCursor = this.getCursorForScale(this.scale);
                if (this.pageImage != null && this.pageImage.length > 0) {
                    int w = (int)((double)(this.pageWidth * this.scale) / 100.0);
                    int h = (int)((double)(this.pageHeight * this.scale) / 100.0);
                    boolean setNewCursor = this.pageImage[0].getCursor() != newCursor;
                    for (int i = 0; i < this.pageImage.length; ++i) {
                        if (this.pageImage[i] == null) continue;
                        this.pageImage[i].setScaledSize(w, h);
                        if (!setNewCursor) continue;
                        this.pageImage[i].setCursor(newCursor);
                    }
                }
                this.previewPanel.revalidate();
            } else if (source.equals(this.numPagesComboBox)) {
                int choice = Integer.parseInt((String)e.getItem());
                choice = Math.min(choice, this.numPages);
                this.setNumVisiblePages(choice);
                this.setPreviewPage(0);
            }
            this.updateButtons();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setCloseButtonText(String text) {
        this.closeButton.setText(text);
    }

    public void setNextPageButtonText(String text) {
        this.nextPageButton.setText(text);
    }

    private void setNumVisiblePages(int num) {
        if (this.numPages <= 0) {
            this.numPages = 1;
        }
        if (num > this.numPages) {
            num = this.numPages;
        }
        this.numVisiblePages = num;
    }

    public void setPrevPageButtonText(String text) {
        this.prevPageButton.setText(text);
    }

    public void setPrintButtonText(String text) {
        this.printButton.setText(text);
    }

    private void setPreviewPage(int pageNumber) {
        this.previewPanel.removeAll();
        this.currentPage = pageNumber;
        this.pageWidth = (int)this.pageFormat.getWidth();
        this.pageHeight = (int)this.pageFormat.getHeight();
        int w = (int)((double)(this.pageWidth * this.scale) / 100.0);
        int h = (int)((double)(this.pageHeight * this.scale) / 100.0);
        try {
            Cursor cursorToUse = this.getCursorForScale(this.scale);
            for (int i = 0; i < this.numVisiblePages; ++i) {
                BufferedImage img = new BufferedImage(this.pageWidth, this.pageHeight, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.pageWidth, this.pageHeight);
                if (this.masterImage.print(g, this.pageFormat, this.currentPage + i) == 0) {
                    this.pageImage[i] = new PagePreview(w, h, img, cursorToUse);
                    this.previewPanel.add(this.pageImage[i]);
                } else {
                    this.pageImage[i] = null;
                }
                g.dispose();
            }
            this.previewPanel.revalidate();
            this.previewPanel.repaint();
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
        }
    }

    public void setScale(int newScale) {
        this.sizeComboBox.setSelectedItem(Integer.toString(newScale) + "%");
    }

    private void updateButtons() {
        this.prevPageButton.setEnabled(this.currentPage > 0);
        this.nextPageButton.setEnabled(this.currentPage < this.numPages - this.numVisiblePages);
    }

    class PagePreview
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected int width;
        protected int height;
        protected BufferedImage sourceImage;
        protected Image drawImage;

        public PagePreview(int width, int height, BufferedImage source, Cursor cursorToUse) {
            this.sourceImage = source;
            this.setScaledSize(width, height);
            this.setBorder(PrintPreviewDialog.this.getPagePreviewBorder());
            this.setCursor(cursorToUse);
            this.enableEvents(16L);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.width + ins.left + ins.right, this.height + ins.top + ins.bottom);
        }

        public BufferedImage getSourceImage() {
            return this.sourceImage;
        }

        public void paintComponent(Graphics g) {
            g.drawImage(this.drawImage, 0, 0, this);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 501 && e.getClickCount() == 1 && e.getButton() == 1) {
                PrintPreviewDialog.this.setScale(this.getCursor() == PrintPreviewDialog.this.zoomInCursor ? 100 : 25);
            }
            super.processMouseEvent(e);
        }

        public void setScaledSize(int width, int height) {
            this.width = width;
            this.height = height;
            this.drawImage = this.sourceImage.getScaledInstance(width, height, 4);
            this.repaint();
        }
    }
}

