package TDS::Tdf::Command;
################################################################

sub EscapeEntity($\$)
{
    my ($self, $line) = @_;

    # 
    $$line =~ s/~$/ /;    

    # λ

    $$line =~ s/\\/\\\\/g;
    $$line =~ s/\$/\\\$/g;
    $$line =~ s/%/\\%/g;
    $$line =~ s/#/\\#/g;
#    $$line =~ s/~/\\~\\quad /g;
    $$line =~ s/~/\\~ /g;
    $$line =~ s/_/\\_/g;
    $$line =~ s/</\$<\$/g;
    $$line =~ s/>/\$>\$/g;
    $$line =~ s/&/\\&/g;
    $$line =~ s/{/\\{/g;
    $$line =~ s/}/\\}/g;
    
#    $$line =~ s/~$/$TDS::Tdf::Command::BR::Template\n/;

    return $$line;
}

################################################################

package TDS::Tdf::Command::HD;

$Template = "";
$EndTemplate = "}\n";

sub AsHTML($$)
{
    my ($self, $params) = @_;
    
    my $num = $self->{attr}->[1];

    $Template = "";
    if ($num == 1){
	$Template = "\\chapter"
    } elsif ($num == 2){
	$Template = "\\section";
    } elsif ($num == 3){
	$Template = "\\subsection";
    } elsif ($num == 4){
	$Template = "\\subsubsection";
    } elsif ($num == 5){
	$Template = "\\paragraph";
    } elsif ($num == 6){
	$Template = "\\subparagraph";
    } else {
	die "HD $num";
    }
    $Template .= "{%content";
    $self->SUPER::AsHTML($params);
}

################################################################

package TDS::Tdf::Command::LINK;

$Template = "";
$EndTemplate = '\footnote{%{1}}';

package TDS::Tdf::Command::ANCHOR;

$Template = "";
$EndTemplate = "";

package TDS::Tdf::Command::MAILTO;

$Template = "";
$EndTemplate = '\footnote{%{1}}';

package TDS::Tdf::Command::STRONG;

$Template = q({\it );
$EndTemplate = q(});

package TDS::Tdf::Command::BR;

$Template = "\\\\\n";
$EndTemplate = "";

package TDS::Tdf::Command::FN;

$Template = q(\footnote{);
$EndTemplate = q(});

sub AsHTML ($$)
{
    my ($self, $params) = @_;

    return $self->SUPER::AsHTML($params);
}

package TDS::Tdf::Command::FN_Formatter;
$Template = undef;
$EndTemplate = undef;

package TDS::Tdf::Command::FN_Content;
$Template = undef;
$EndTemplate = undef;

package TDS::Tdf::Command::ITALIC;

$Template = q({\it );
$EndTemplate = q(});

################################################################
package TDS::Tdf::Command::P;

$Template = "\n\n";
$EndTemplate = "\n\n";

package TDS::Tdf::Command::SPAN;

$Template = "%content";
$EndTemplate = "";

package TDS::Tdf::Command::DL;

$Template = "\\begin{description}\n";
$EndTemplate = "\\end{description}\n";

package TDS::Tdf::Command::DT;

$Template = "\\item [%content";
$EndTemplate = "\\quad]\n";

package TDS::Tdf::Command::DD;

$Template = "%content";
$EndTemplate = "\n";

package TDS::Tdf::Command::UL;

$Template = "\\begin{itemize}\n";
$EndTemplate = "\\end{itemize}\n";

package TDS::Tdf::Command::OL;

$Template = "\\begin{enumerate}\n";
$EndTemplate = "\\end{enumerate}\n";

package TDS::Tdf::Command::LI;

$Template = "\\item %content\n";
$EndTemplate = "";

package TDS::Tdf::Command::CITE;

$Template = "";
$EndTemplate = "";

package TDS::Tdf::Command::CODE;

$Template = "\\begin{verbatim}";
$EndTemplate = "\\end{verbatim}";

sub EscapeEntity ($\$)
{
    my ($self, $line);
    return $$line;
}

package TDS::Tdf::Command::PRE;

$Template = "\\begin{verbatim}";
$EndTemplate = "\\end{verbatim}";

sub EscapeEntity ($\$)
{
    my ($self, $line);
    return $$line;
}


package TDS::Tdf::Command::COMMENT;

sub AsHTML ()
{
    return undef;
}

package TDS::Tdf::Command::VERBATIM;

$Template = "\\begin{verbatim}";
$EndTemplate = "\\end{verbatim}";

sub EscapeEntity ($\$)
{
    my ($self, $line);
    return $$line;
}

package TDS::Tdf::Command::NOPARSE;

$Template = "\\begin{verbatim}";
$EndTemplate = "\\end{verbatim}";

sub EscapeEntity ($\$)
{
    my ($self, $line);
    return $$line;
}

1;
