#   Copyright (C) 1987-2007 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Sun Jan 28 20:11:59 2007
#

proc resetTechList {} {
  global gatesetech_w

  set tech_w .sbar.tech.v
  set L [gat_getTechList]

  Dropbox::flush $tech_w
  Dropbox::itemadd $tech_w $L

  #
  # Build menus for plain entry technology lists
  #
  set menu_list [list $gatesetech_w]
  foreach m $menu_list {
    catch {
      destroy $m
      menu $m  -tearoff 0 
      foreach mi $L {
	$m add command -label $mi -command "gat_setTech $mi"
      }
    }
  }

  #
  # Build menus for radio button technology lists
  #
  set menu_list [list .pop_MIgate.settech .pop_gate.settech .pop_multi.settech]
  foreach m $menu_list {
    catch {
      destroy $m
      menu $m  -tearoff 0 
      foreach mi $L {
	$m add radiobutton -variable pop_tech -value $mi -label $mi -command "gat_setTech $mi"
      }
    }
  }
}

frame .tbar.f
button .tbar.f.new -image [gifI "$bd/file_new.gif"]  -command {clearAction tkg_new} -takefocus 0
button .tbar.f.open -image [gifI "$bd/file_open.gif"] -command {clearAction tkg_load} -takefocus 0
button .tbar.f.save -image [gifI "$bd/file_save.gif"] -command {suspendAction tkg_saveCurrent} -takefocus 0
button .tbar.f.print -image [gifI "$bd/file_print.gif"] -command {suspendAction tkg_printDlg} -takefocus 0

pack .tbar.f.new .tbar.f.open .tbar.f.save .tbar.f.print -side left -pady 5

helpon .tbar.f.new [m ho.new]
helpon .tbar.f.open [m ho.open]
helpon .tbar.f.save [m ho.save]
helpon .tbar.f.print [m ho.print]

frame .tbar.m
radiobutton .tbar.m.mov -bitmap "@$bd/mov_curs.b" -indicatoron false -variable mode -value 1 -takefocus 0 -command act_editMode
radiobutton .tbar.m.del -bitmap "@$bd/del_curs.b" -indicatoron false -variable mode -value 3 -takefocus 0 -command act_deleteMode
radiobutton .tbar.m.cut -bitmap "@$bd/cut_curs.b" -indicatoron false -variable mode -value 0 -takefocus 0 -command act_cutMode
radiobutton .tbar.m.inv -bitmap "@$bd/inv_curs.b" -indicatoron false -variable mode -value 2 -takefocus 0 -command act_invertMode
radiobutton .tbar.m.siz -bitmap "@$bd/size_curs.b" -indicatoron false -variable mode -value 9 -takefocus 0 -command act_sizeMode
pack .tbar.m.mov .tbar.m.del .tbar.m.cut .tbar.m.inv .tbar.m.siz -side left -pady 5 -ipadx 1 -ipady 1

helpon .tbar.m.mov [m ho.move]

helpon .tbar.m.del [m ho.delgat]
helpon .tbar.m.cut [m ho.cutw]
helpon .tbar.m.inv [m ho.inv]
helpon .tbar.m.siz [m ho.bitw]

frame .tbar.redit
button .tbar.redit.currot -image [gifI "$bd/rotation0_S.gif"]  -command { advanceRotation } -takefocus 0
button .tbar.redit.ccrot -image [gifI "$bd/edit_rotate.gif"]  -command { act_rotate } -takefocus 0
button .tbar.redit.cwrot -image [gifI "$bd/edit_brotate.gif"]  -command { act_backRotate } -takefocus 0
pack .tbar.redit.currot  .tbar.redit.ccrot  .tbar.redit.cwrot  -side left -pady 5 -ipadx 1 -ipady 1

helpon .tbar.redit.currot [m ho.currot]
helpon .tbar.redit.ccrot [m ho.ccrot]
helpon .tbar.redit.cwrot [m ho.cwrot]

frame .tbar.du
label .tbar.du.back -image [gifI "$bd/back.gif"] -bd 2 -relief raised -takefocus 0
label .tbar.du.forward -image [gifI "$bd/forward.gif"] -bd 2 -relief raised -takefocus 0
pack .tbar.du.back .tbar.du.forward  -side left -pady 5 -ipadx 1 -ipady 1
bind .tbar.du.back <Button-1> { %W configure  -relief sunken ;tkg_undoSelect; %W configure  -relief raised }
bind .tbar.du.forward <Button-1>  { %W configure  -relief sunken ;tkg_redoSelect; %W configure  -relief raised }

helpon .tbar.du.back [m ho.undo]
helpon .tbar.du.forward [m ho.redo]


frame .tbar.b
button .tbar.b.open -image [gifI "$bd/blk_open.gif"] -command { action Open { gat_openBox } } -takefocus 0
button .tbar.b.close -image [gifI "$bd/blk_close.gif"] -command { action Close { gat_closeBox } } -takefocus 0
pack .tbar.b.open .tbar.b.close  -side left -pady 5

helpon .tbar.b.open [m ho.modopen]
helpon .tbar.b.close [m ho.modclose]

frame .tbar.z
button .tbar.z.zoomin -image [gifI "$bd/zoom_in.gif"] -command { action ZoomIn { gat_zoom 1 } } -takefocus 0
button .tbar.z.zoomout -image [gifI "$bd/zoom_out.gif"] -command { action ZoomOut { gat_zoom -1 } } -takefocus 0 -state disabled
pack .tbar.z.zoomin .tbar.z.zoomout  -side left -pady 5


helpon .tbar.z.zoomin [m zoomin]
helpon .tbar.z.zoomout [m zoomout]

frame .tbar.s
button .tbar.s.simgo -image [gifI "$bd/sim_go.gif"] -command tkg_simRun -takefocus 0
button .tbar.s.simpause -image [gifI "$bd/sim_pause.gif"] -command tkg_simStop -takefocus 0
button .tbar.s.simstep -image [gifI "$bd/sim_step.gif"] -command tkg_simStep -takefocus 0
button .tbar.s.simclock -image [gifI "$bd/sim_clock.gif"] -command tkg_simCycle -takefocus 0
button .tbar.s.simstop -image [gifI "$bd/sim_stop.gif"] -command { gat_setMajorMode edit } -takefocus 0
pack .tbar.s.simgo .tbar.s.simpause .tbar.s.simstep .tbar.s.simclock .tbar.s.simstop -side left -pady 5

helpon .tbar.s.simgo [m ho.simgo]
helpon .tbar.s.simpause [m ho.simpause]
helpon .tbar.s.simstep [m ho.simstep]
helpon .tbar.s.simclock [m ho.simclock]
helpon .tbar.s.simstop [m ho.simstop]

frame .tbar.sc
button .tbar.sc.simbreak -image [gifI "$bd/sim_break.gif"] -takefocus 0 -command tkg_editBreakpoints
button .tbar.sc.simscript -image [gifI "$bd/sim_script.gif"] -takefocus 0 -command tkg_doSimScript
button .tbar.sc.simload -image [gifI "$bd/sim_load.gif"] -takefocus 0 -command tkg_simLoadMem
button .tbar.sc.simdump -image [gifI "$bd/sim_dump.gif"] -takefocus 0 -command tkg_simDumpMem
pack .tbar.sc.simbreak .tbar.sc.simscript .tbar.sc.simload .tbar.sc.simdump -side left -pady 5

helpon .tbar.sc.simbreak [m ho.simbreak]
helpon .tbar.sc.simscript [m ho.simexec]
helpon .tbar.sc.simload [m ho.simload]
helpon .tbar.sc.simdump [m ho.simdump]

#pack .tbar.s .tbar.sc -side left -padx 5

frame .tbar.mode
button .tbar.mode.simgo -image [gifI "$bd/simstart.gif"] -command tkg_simRun -takefocus 0
button .tbar.mode.anal -image [gifI "$bd/analyze.gif"] -takefocus 0 -command tkg_cpathAnal
pack .tbar.mode.simgo .tbar.mode.anal -side left -pady 5

helpon .tbar.mode.simgo [m ho.simstart]
helpon .tbar.mode.anal [m ho.cpathanal]

proc toolbar:hideEdit {} {
     pack forget .tbar.m
     pack forget .tbar.du
     pack forget .tbar.mode
     pack forget .tbar.redit
}

proc toolbar:showEdit {} {
   pack configure .tbar.m .tbar.redit .tbar.du -side left -padx 5 -after .tbar.f
   pack .tbar.mode -side left -padx 5
}

proc toolbar:showSim {} {
    pack .tbar.s .tbar.sc -side left -padx 5
}

proc toolbar:hideSim {} {
    pack forget .tbar.s .tbar.sc
}

trace variable rot w updateRotation
proc updateRotation {args} {
  global rot bd

  switch $rot {
    0 { .tbar.redit.currot configure -image [gifI "$bd/rotation0_S.gif"] }
    1 { .tbar.redit.currot configure -image [gifI "$bd/rotation90_S.gif"] }
    2 { .tbar.redit.currot configure -image [gifI "$bd/rotation180_S.gif"] }
    3 { .tbar.redit.currot configure -image [gifI "$bd/rotation270_S.gif"] }
  }
}

proc advanceRotation {} {
  global rot

  set rot [expr ($rot + 1) % 4]
  switch $rot {
    0 { act_rot0 }
    1 { act_rot90 }
    2 { act_rot180 }
    3 { act_rot270 }
  }
}

#
# Initial toolbar placement...
#
pack .tbar.f .tbar.m .tbar.redit .tbar.du .tbar.b .tbar.z  .tbar.mode -side left -padx 5
