/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

import GoGrinder.Main;
import GoGrinder.Messages;
import GoGrinder.WGFController;
import GoGrinder.ui.WGFFrame;

/**
 * @author tkington
 */
public class WGFSaveAction extends WGFAction {
	public WGFSaveAction(WGFFrame frame, WGFController controller) {
		super(frame, controller);
		putValue(NAME, Messages.getString("WGFSaveAction.Save")); //$NON-NLS-1$
		putValue(SHORT_DESCRIPTION, Messages.getString("WGFFrame.SaveFile")); //$NON-NLS-1$
		putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
		putValue(SMALL_ICON, Main.getIcon("Save16.gif", frame)); //$NON-NLS-1$
	}

	public void actionPerformed(ActionEvent evt) {
        controller.saveFile();
	}
}
