/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.formatter;

import java.io.Writer;
import java.util.Date;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.formatter.Formatter;
import net.loomchild.maligna.util.Util;
import net.loomchild.maligna.util.bind.TmxMarshallerUnmarshaller;
import net.loomchild.maligna.util.bind.tmx.Body;
import net.loomchild.maligna.util.bind.tmx.Header;
import net.loomchild.maligna.util.bind.tmx.Seg;
import net.loomchild.maligna.util.bind.tmx.Tmx;
import net.loomchild.maligna.util.bind.tmx.Tu;
import net.loomchild.maligna.util.bind.tmx.Tuv;
import net.loomchild.maligna.util.date.DateParser;

public class TmxFormatter
implements Formatter {
    public static final String TMX_VERSION = "1.4b";
    public static final String TMX_ADMINLANG = "en";
    public static final String TMX_CREATIONTOOL = "mALIGNa";
    public static final String TMX_CREATIONTOOLVERSION = "2";
    public static final String TMX_SEGTYPE = "block";
    public static final String TMX_DATATYPE = "plaintext";
    public static final String TMX_OTMF = "al";
    private String sourceLanguageCode;
    private String targetLanguageCode;
    private Writer writer;

    public TmxFormatter(Writer writer, String sourceLanguageCode, String targetLanguageCode) {
        this.writer = writer;
        this.sourceLanguageCode = sourceLanguageCode;
        this.targetLanguageCode = targetLanguageCode;
    }

    @Override
    public void format(List<Alignment> alignmentList) {
        Tmx tmx = new Tmx();
        tmx.setVersion(TMX_VERSION);
        Header header = new Header();
        header.setAdminlang(TMX_ADMINLANG);
        header.setSrclang(this.sourceLanguageCode);
        header.setCreationtool(TMX_CREATIONTOOL);
        header.setCreationtoolversion(TMX_CREATIONTOOLVERSION);
        header.setSegtype(TMX_SEGTYPE);
        header.setDatatype(TMX_DATATYPE);
        header.setOTmf(TMX_OTMF);
        header.setCreationdate(DateParser.getIsoDateNoMillis(new Date()));
        tmx.setHeader(header);
        Body body = new Body();
        for (Alignment alignment : alignmentList) {
            Tu tu = new Tu();
            this.createTuv(tu, this.sourceLanguageCode, alignment.getSourceSegmentList());
            this.createTuv(tu, this.targetLanguageCode, alignment.getTargetSegmentList());
            if (tu.getTuv().size() <= 0) continue;
            body.getTu().add(tu);
        }
        tmx.setBody(body);
        TmxMarshallerUnmarshaller.getInstance().marshal(tmx, this.writer);
    }

    private void createTuv(Tu tu, String languageCode, List<String> segmentList) {
        if (segmentList.size() > 0) {
            Tuv tuv = new Tuv();
            tuv.setLang(languageCode);
            Seg seg = new Seg();
            String segment = Util.merge(segmentList);
            seg.getContent().add(segment);
            tuv.setSeg(seg);
            tu.getTuv().add(tuv);
        }
    }
}

