/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.madlonkay.supertmxmerge.MergeController;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTmx;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.gui.ProgressWindow;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class CombineIOController {
    private static final Logger LOGGER = Logger.getLogger(CombineIOController.class.getName());
    private final PropertyChangeSupport propertySupport;
    public static final String PROP_INPUTISVALID = "inputIsValid";
    public static final String PROP_OUTPUTFILE = "outputFile";
    private List<File> files = new ArrayList<File>();
    private File outputFile;
    private boolean isDone;

    public CombineIOController() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void addFile(File file) {
        if (!this.files.contains(file)) {
            this.files.add(file);
            this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
        }
    }

    public void setFiles(Enumeration<File> files) {
        this.files = Collections.list(files);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public void setFiles(File[] files) {
        this.files = Arrays.asList(files);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public boolean getInputIsValid() {
        return this.files.size() >= 2;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        File oldOutputFile = this.outputFile;
        this.outputFile = outputFile;
        this.propertySupport.firePropertyChange(PROP_OUTPUTFILE, oldOutputFile, outputFile);
    }

    public void go() {
        this.isDone = false;
        GuiUtil.safelyRunBlockingRoutine(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                new CombineWorker(CombineIOController.this.getFiles()).run();
                try {
                    CombineIOController combineIOController = CombineIOController.this;
                    synchronized (combineIOController) {
                        while (!CombineIOController.this.isDone) {
                            CombineIOController.this.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void writeOutputFile(ITmx combined) throws WriteFailedException {
        if (combined == null) {
            return;
        }
        while (this.getOutputFile() == null) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showSaveDialog(null) == 0) {
                this.setOutputFile(chooser.getSelectedFile());
                continue;
            }
            int response = JOptionPane.showConfirmDialog(null, LocString.get("STM_CONFIRM_CANCEL_SAVE_MESSAGE"), LocString.get("STM_COMBINE_WINDOW_TITLE"), 0, 2);
            if (response != 0) continue;
            return;
        }
        combined.writeTo(this.getOutputFile());
    }

    private class CombineWorker
    extends SwingWorker<ITmx, Object[]> {
        private final ProgressWindow progress = new ProgressWindow();
        private final List<File> files;

        public CombineWorker(List<File> files) {
            this.progress.setMustPopup(true);
            this.progress.setMaximum(files.size());
            this.files = files;
        }

        @Override
        protected ITmx doInBackground() throws Exception {
            File firstFile = this.files.get(0);
            this.publish((V[])new Object[][]{{0, LocString.getFormat("STM_FILE_PROGRESS", firstFile.getName(), 1, this.files.size())}});
            JAXBTmx combined = new JAXBTmx(firstFile);
            JAXBTmx empty = JAXBTmx.newEmptyJAXBTmx(combined);
            MergeController merger = new MergeController();
            merger.setIsTwoWayMerge(true);
            for (int i = 1; i < this.files.size(); ++i) {
                File file = this.files.get(i);
                this.publish((V[])new Object[][]{{i, LocString.getFormat("STM_FILE_PROGRESS", file.getName(), i + 1, this.files.size())}});
                JAXBTmx next = new JAXBTmx(file);
                combined = (JAXBTmx)merger.merge(empty, combined, next);
                if (combined != null) continue;
                return null;
            }
            this.publish((V[])new Object[][]{{this.files.size()}});
            return combined;
        }

        @Override
        protected void process(List<Object[]> chunks) {
            Object[] last = chunks.get(chunks.size() - 1);
            this.progress.setValue((Integer)last[0]);
            if (last.length > 1) {
                this.progress.setMessage((String)last[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            ITmx result;
            try {
                result = (ITmx)this.get();
            }
            catch (Exception ex) {
                GuiUtil.showError(LocString.getFormat("STM_LOAD_ERROR", ex));
                throw new RuntimeException(ex);
            }
            finally {
                GuiUtil.closeWindow(this.progress);
            }
            try {
                CombineIOController.this.writeOutputFile(result);
            }
            catch (WriteFailedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            finally {
                CombineIOController combineIOController = CombineIOController.this;
                synchronized (combineIOController) {
                    CombineIOController.this.isDone = true;
                    CombineIOController.this.notify();
                }
            }
        }
    }
}

