/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.compiler;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.java.sen.util.CSVParser;
import net.java.sen.util.IOUtils;

class CostMatrixBuilder {
    private LinkedHashSet<String> ruleSet = new LinkedHashSet();
    private Vector<String[]> ruleList = new Vector();
    private Vector<Vector<Integer>> idList = new Vector();
    private Map<String, Integer> dicIndex = new HashMap<String, Integer>();
    private Map<String, Integer> ruleIndex = new HashMap<String, Integer>();
    private Set<String> lexicalized = new HashSet<String>();

    CostMatrixBuilder() {
    }

    private Vector<Integer> getIdList(String[] csv, boolean parent) {
        int j;
        Vector<Integer> results = new Vector<Integer>(this.ruleList.size());
        results.setSize(this.ruleList.size());
        for (j = 0; j < this.ruleList.size(); ++j) {
            results.set(j, j);
        }
        for (j = 0; j < csv.length; ++j) {
            int k = 0;
            for (int n = 0; n < results.size(); ++n) {
                int i = results.get(n);
                String rl_ij = this.ruleList.get(i)[j];
                if (!(!parent && csv[j].charAt(0) == '*' || parent && rl_ij.charAt(0) == '*') && !rl_ij.equals(csv[j])) continue;
                results.set(k++, results.get(n));
            }
            results.setSize(k);
        }
        return results;
    }

    private int getDicIdNoCache(String[] csv) {
        Vector<Integer> results = this.getIdList(csv, true);
        if (results.size() == 0) {
            throw new IllegalArgumentException();
        }
        int[] priority = new int[results.size()];
        int max = 0;
        for (int i = 0; i < results.size(); ++i) {
            String[] csvValues = this.ruleList.get(results.get(i));
            for (int j = 0; j < csvValues.length; ++j) {
                if (csvValues[j].charAt(0) == '*') continue;
                int n = i;
                priority[n] = priority[n] + 1;
            }
            if (priority[max] >= priority[i]) continue;
            max = i;
        }
        return results.get(max);
    }

    public void add(String rule) {
        this.ruleSet.add(rule);
    }

    public void build() {
        int i = 0;
        this.ruleList.setSize(this.ruleSet.size());
        for (String str : this.ruleSet) {
            this.ruleIndex.put(str, i);
            String[] tokenList = str.split(",");
            this.ruleList.set(i, tokenList);
            if (tokenList[tokenList.length - 1].charAt(0) != '*') {
                this.lexicalized.add(tokenList[tokenList.length - 1]);
            }
            ++i;
        }
        this.ruleSet.clear();
        this.idList.setSize(this.ruleList.size());
        for (int j = 0; j < this.ruleList.size(); ++j) {
            Vector<Integer> results = this.getIdList(this.ruleList.get(j), false);
            this.idList.set(j, results);
        }
    }

    public int size() {
        return this.ruleList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDicId(String rule) throws IOException {
        String partOfSpeech;
        String[] csv;
        CSVParser parser;
        block5: {
            block4: {
                int n;
                parser = null;
                try {
                    parser = new CSVParser(rule);
                    csv = parser.nextTokens();
                    String lex = csv[csv.length - 1];
                    if (!this.lexicalized.contains(lex)) break block4;
                    n = this.getDicIdNoCache(csv);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException(parser);
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(parser);
                return n;
            }
            partOfSpeech = rule.substring(0, rule.lastIndexOf(","));
            Integer r = this.dicIndex.get(partOfSpeech);
            if (r == null || r == 0) break block5;
            int n = r - 1;
            IOUtils.closeWhileHandlingException(parser);
            return n;
        }
        int rg = this.getDicIdNoCache(csv);
        this.dicIndex.put(partOfSpeech, rg + 1);
        int n = rg;
        IOUtils.closeWhileHandlingException(parser);
        return n;
    }

    public Vector<Integer> getRuleIdList(String rule) {
        return this.idList.get(this.ruleIndex.get(rule));
    }
}

