/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.GuiceHelper;
import org.testng.IClass;
import org.testng.IInjectorFactory;
import org.testng.ISuite;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.IParameterInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.objects.Dispenser;
import org.testng.internal.objects.IObjectDispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;
import org.testng.internal.objects.pojo.DetailedAttributes;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public class ClassImpl
implements IClass {
    private final Class<?> m_class;
    private Object m_defaultInstance = null;
    private final IAnnotationFinder m_annotationFinder;
    private final List<Object> m_instances = Lists.newArrayList();
    private final Map<Class<?>, IClass> m_classes;
    private long[] m_instanceHashCodes;
    private final Object m_instance;
    private final ITestObjectFactory m_objectFactory;
    private String m_testName = null;
    private final XmlClass m_xmlClass;
    private final ITestContext m_testContext;
    private final boolean m_hasParentModule;

    public ClassImpl(ITestContext context, Class<?> cls, XmlClass xmlClass, Object instance, Map<Class<?>, IClass> classes, IAnnotationFinder annotationFinder, ITestObjectFactory objectFactory) {
        ITestAnnotation annotation;
        this.m_testContext = context;
        this.m_class = cls;
        this.m_classes = classes;
        this.m_xmlClass = xmlClass;
        this.m_annotationFinder = annotationFinder;
        this.m_instance = instance;
        this.m_objectFactory = objectFactory;
        if (instance instanceof ITest) {
            this.m_testName = ((ITest)instance).getTestName();
        }
        if (this.m_testName == null && (annotation = this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class)) != null && !annotation.getTestName().isEmpty()) {
            this.m_testName = annotation.getTestName();
        }
        this.m_hasParentModule = Utils.isStringNotEmpty(this.m_testContext.getSuite().getParentModule());
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    @Override
    public Class<?> getRealClass() {
        return this.m_class;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashCodes;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_testContext.getCurrentXmlTest();
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    private Object getDefaultInstance(boolean create, String errMsgPrefix) {
        if (this.m_defaultInstance == null) {
            if (this.m_instance != null) {
                this.m_defaultInstance = this.m_instance;
            } else {
                IObjectDispenser dispenser = Dispenser.newInstance();
                BasicAttributes basic = new BasicAttributes(this, null);
                DetailedAttributes detailed = this.newDetailedAttributes(create, errMsgPrefix);
                CreationAttributes attributes = new CreationAttributes(this.m_testContext, basic, detailed);
                this.m_defaultInstance = dispenser.dispense(attributes);
            }
        }
        return this.m_defaultInstance;
    }

    private Object getInstanceFromGuice() {
        Injector injector = this.m_testContext.getInjector(this);
        if (injector == null) {
            return null;
        }
        return injector.getInstance(this.m_class);
    }

    @Deprecated
    public Injector getParentInjector(IInjectorFactory injectorFactory) {
        ISuite suite = this.m_testContext.getSuite();
        Injector injector = suite.getParentInjector();
        if (injector == null) {
            Module parentModule = GuiceHelper.getParentModule(this.m_testContext);
            injector = GuiceHelper.createInjector(null, this.m_testContext, injectorFactory, parentModule == null ? Collections.emptyList() : Collections.singletonList(parentModule));
            suite.setParentInjector(injector);
        }
        return injector;
    }

    @Override
    public Object[] getInstances(boolean create) {
        return this.getInstances(create, "");
    }

    @Override
    public Object[] getInstances(boolean create, String errorMsgPrefix) {
        Object[] result = new Object[]{};
        if (this.m_testContext.getCurrentXmlTest().isJUnit() && create) {
            DetailedAttributes ea = this.newDetailedAttributes(create, errorMsgPrefix);
            CreationAttributes attributes = new CreationAttributes(this.m_testContext, null, ea);
            result = new Object[]{Dispenser.newInstance().dispense(attributes)};
        }
        if (this.m_instances.size() > 0) {
            result = this.m_instances.toArray(new Object[0]);
        } else {
            Object defaultInstance = this.getDefaultInstance(create, errorMsgPrefix);
            if (defaultInstance != null) {
                result = new Object[]{defaultInstance};
            }
        }
        int m_instanceCount = this.m_instances.size();
        this.m_instanceHashCodes = new long[m_instanceCount];
        for (int i = 0; i < m_instanceCount; ++i) {
            this.m_instanceHashCodes[i] = ClassImpl.computeHashCode(this.m_instances.get(i));
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_class.getName()).toString();
    }

    @Override
    public void addInstance(Object instance) {
        this.m_instances.add(instance);
    }

    private static int computeHashCode(Object instance) {
        return IParameterInfo.embeddedInstance(instance).hashCode();
    }

    private DetailedAttributes newDetailedAttributes(boolean create, String errMsgPrefix) {
        DetailedAttributes ea = new DetailedAttributes();
        ea.setXmlTest(this.m_testContext.getCurrentXmlTest());
        ea.setClasses(this.m_classes);
        ea.setFinder(this.m_annotationFinder);
        ea.setDeclaringClass(this.m_class);
        ea.setFactory(this.m_objectFactory);
        ea.setErrorMsgPrefix(errMsgPrefix);
        ea.setCreate(create);
        return ea;
    }
}

