/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.omegat.core.Core;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SegmentProperties;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;
import org.omegat.util.TMXReader2;

public final class ExternalTMFactory {
    private ExternalTMFactory() {
    }

    public static boolean isSupported(File file) {
        return TMXLoader.isSupported(file) || BifileLoader.isSupported(file);
    }

    public static ExternalTMX load(File file) throws Exception {
        ProjectProperties props = Core.getProject().getProjectProperties();
        if (TMXLoader.isSupported(file)) {
            return new TMXLoader(file).setExtTmxLevel2(Preferences.isPreference("ext_tmx_show_level2")).setUseSlash(Preferences.isPreference("ext_tmx_use_slash")).setDoSegmenting(props.isSentenceSegmentingEnabled()).setKeepForeignMatches(Preferences.isPreference("keep_foreign_matches")).load(props.getSourceLanguage(), props.getTargetLanguage());
        }
        if (BifileLoader.isSupported(file)) {
            return new BifileLoader(file).setRemoveTags(props.isRemoveTags()).setRemoveSpaces(Core.getFilterMaster().getConfig().isRemoveSpacesNonseg()).setDoSegmenting(props.isSentenceSegmentingEnabled()).load(props.getSourceLanguage(), props.getTargetLanguage());
        }
        throw new IllegalArgumentException("Unsupported external TM type: " + file.getName());
    }

    private static PrepareTMXEntry makeEntry(String source, String target, String id, String comment, String path, String[] props) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        entry.source = source;
        entry.translation = target;
        entry.note = comment;
        List<Object> tmxProps = Collections.emptyList();
        if (props != null) {
            tmxProps = ExternalTMFactory.propsToList(props);
            if (id != null) {
                tmxProps.add(new TMXProp("id", id));
            }
            if (path != null) {
                tmxProps.add(new TMXProp("path", path));
            }
            if (entry.note == null) {
                entry.note = SegmentProperties.getProperty(props, "comment");
            }
        }
        entry.otherProperties = tmxProps;
        return entry;
    }

    private static List<TMXProp> propsToList(String[] props) {
        ArrayList<TMXProp> result = new ArrayList<TMXProp>(props.length / 2);
        for (int i = 0; i < props.length; ++i) {
            result.add(new TMXProp(props[i], props[++i]));
        }
        return result;
    }

    public static final class Builder {
        private final String name;
        private final List<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();

        public Builder(String name) {
            this.name = name;
        }

        public void addEntry(String source, String target, String id, String path, String[] props) {
            if (!source.trim().isEmpty()) {
                this.entries.add(ExternalTMFactory.makeEntry(source, target, id, null, path, props));
            }
        }

        public ExternalTMX done() {
            return new ExternalTMX(this.name, this.entries);
        }
    }

    public static final class BifileLoader {
        private final File file;
        private boolean removeTags;
        private boolean removeSpaces;
        private boolean doSegmenting;

        public static boolean isSupported(File file) {
            FilterMaster fm = Core.getFilterMaster();
            try {
                return fm.isFileSupported(file, true) && fm.isBilingualFile(file);
            }
            catch (Exception e) {
                return false;
            }
        }

        public BifileLoader(File file) {
            this.file = file;
        }

        public BifileLoader setRemoveTags(boolean removeTags) {
            this.removeTags = removeTags;
            return this;
        }

        public BifileLoader setRemoveSpaces(boolean removeSpaces) {
            this.removeSpaces = removeSpaces;
            return this;
        }

        public BifileLoader setDoSegmenting(boolean doSegmenting) {
            this.doSegmenting = doSegmenting;
            return this;
        }

        public ExternalTMX load(Language sourceLang, Language targetLang) throws Exception {
            return new ExternalTMX(this.file.getName(), this.loadImpl(sourceLang, targetLang));
        }

        private List<PrepareTMXEntry> loadImpl(final Language sourceLang, final Language targetLang) throws Exception {
            final ArrayList<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();
            final ParseEntry.ParseEntryResult throwaway = new ParseEntry.ParseEntryResult();
            Core.getFilterMaster().loadFile(this.file.getPath(), new FilterContext(sourceLang, targetLang, true).setRemoveAllTags(this.removeTags), new IParseCallback(){

                @Override
                public void linkPrevNextSegments() {
                }

                @Override
                public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, IFilter filter) {
                    this.process(source, translation, id, comment, null, null);
                }

                @Override
                public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                    this.process(source, translation, id, comment, path, null);
                }

                @Override
                public void addEntryWithProperties(String id, String source, String translation, boolean isFuzzy, String[] props, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                    this.process(source, translation, id, null, null, props);
                }

                private void process(String source, String target, String id, String comment, String path, String[] props) {
                    if (source == null || target == null) {
                        return;
                    }
                    source = StringUtil.normalizeUnicode(ParseEntry.stripSomeChars(source, throwaway, removeTags, removeSpaces));
                    target = StringUtil.normalizeUnicode(ParseEntry.stripSomeChars(target, throwaway, removeTags, removeSpaces));
                    ArrayList<String> sources = new ArrayList<String>();
                    ArrayList<String> targets = new ArrayList<String>();
                    Core.getSegmenter().segmentEntries(doSegmenting, sourceLang, source, targetLang, target, sources, targets);
                    if (sources.size() == targets.size()) {
                        for (int i = 0; i < sources.size(); ++i) {
                            this.addImpl((String)sources.get(i), (String)targets.get(i), id, comment, path, props);
                        }
                    } else {
                        this.addImpl(source, target, id, comment, path, props);
                    }
                }

                private void addImpl(String source, String target, String id, String comment, String path, String[] props) {
                    if (!source.trim().isEmpty()) {
                        entries.add(ExternalTMFactory.makeEntry(source, target, id, comment, path, props));
                    }
                }
            });
            return entries;
        }
    }

    public static final class TMXLoader {
        public static final String PROP_SOURCE_LANGUAGE = "sourceLanguage";
        public static final String PROP_TARGET_LANGUAGE = "targetLanguage";
        public static final String PROP_FOREIGN_MATCH = "foreignMatch";
        private final File file;
        private boolean extTmxLevel2;
        private boolean useSlash;
        private boolean doSegmenting;
        private boolean keepForeignMatches;

        public static boolean isSupported(File file) {
            String name = file.getName().toLowerCase(Locale.ENGLISH);
            return name.endsWith(".tmx") || name.endsWith(".tmx.gz") || name.endsWith(".tmx.zip");
        }

        public TMXLoader(File file) {
            this.file = file;
        }

        public TMXLoader setExtTmxLevel2(boolean extTmxLevel2) {
            this.extTmxLevel2 = extTmxLevel2;
            return this;
        }

        public TMXLoader setUseSlash(boolean useSlash) {
            this.useSlash = useSlash;
            return this;
        }

        public TMXLoader setDoSegmenting(boolean doSegmenting) {
            this.doSegmenting = doSegmenting;
            return this;
        }

        public TMXLoader setKeepForeignMatches(boolean keepForeignMatches) {
            this.keepForeignMatches = keepForeignMatches;
            return this;
        }

        public ExternalTMX load(Language sourceLang, Language targetLang) throws Exception {
            return new ExternalTMX(this.file.getName(), this.loadImpl(sourceLang, targetLang));
        }

        private List<PrepareTMXEntry> loadImpl(final Language sourceLang, final Language targetLang) throws Exception {
            final ArrayList<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();
            TMXReader2.LoadCallback loader = new TMXReader2.LoadCallback(){

                @Override
                public boolean onEntry(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
                    if (tuvSource == null) {
                        return false;
                    }
                    for (TMXReader2.ParsedTuv tuvTarget2 : tu.tuvs) {
                        boolean isForeign;
                        if (tuvTarget2 == tuvSource || sourceLang.equals(new Language(tuvTarget2.lang))) continue;
                        boolean bl = isForeign = !targetLang.isSameLanguage(tuvTarget2.lang);
                        if (isForeign && !keepForeignMatches) continue;
                        this.addTuv(tu, tuvSource, tuvTarget2, isParagraphSegtype, isForeign);
                    }
                    return true;
                }

                private void addTuv(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype, boolean nonTarget) {
                    String changer = StringUtil.nvl(tuvTarget.changeid, tuvTarget.creationid, tu.changeid, tu.creationid);
                    String creator = StringUtil.nvl(tuvTarget.creationid, tu.creationid);
                    long changed = StringUtil.nvlLong(tuvTarget.changedate, tuvTarget.creationdate, tu.changedate, tu.creationdate);
                    long created = StringUtil.nvlLong(tuvTarget.creationdate, tu.creationdate);
                    ArrayList<String> sources = new ArrayList<String>();
                    ArrayList<String> targets = new ArrayList<String>();
                    Core.getSegmenter().segmentEntries(doSegmenting && isParagraphSegtype, sourceLang, tuvSource.text, targetLang, tuvTarget.text, sources, targets);
                    for (int i = 0; i < sources.size(); ++i) {
                        PrepareTMXEntry te = new PrepareTMXEntry();
                        te.source = (String)sources.get(i);
                        te.translation = (String)targets.get(i);
                        te.changer = changer;
                        te.changeDate = changed;
                        te.creator = creator;
                        te.creationDate = created;
                        te.note = tu.note;
                        te.otherProperties = new ArrayList<TMXProp>(tu.props);
                        te.otherProperties.add(new TMXProp(TMXLoader.PROP_SOURCE_LANGUAGE, tuvSource.lang));
                        te.otherProperties.add(new TMXProp(TMXLoader.PROP_TARGET_LANGUAGE, tuvTarget.lang));
                        if (nonTarget) {
                            te.otherProperties.add(new TMXProp(TMXLoader.PROP_FOREIGN_MATCH, "true"));
                        }
                        entries.add(te);
                    }
                }
            };
            TMXReader2 reader = new TMXReader2();
            reader.readTMX(this.file, sourceLang, targetLang, this.doSegmenting, false, this.extTmxLevel2, this.useSlash, loader);
            return entries;
        }
    }
}

