/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.omegat.gui.glossary.DefaultGlossaryRenderer;
import org.omegat.gui.glossary.DictionaryGlossaryRenderer;
import org.omegat.gui.glossary.IGlossaryRenderer;
import org.omegat.util.Preferences;

public class GlossaryRenderers {
    public static final IGlossaryRenderer DEFAULT_RENDERER = new DefaultGlossaryRenderer();
    private static final List<IGlossaryRenderer> GLOSSARY_RENDERERS = new ArrayList<IGlossaryRenderer>();
    private static IGlossaryRenderer preferred;

    private GlossaryRenderers() {
    }

    public static List<IGlossaryRenderer> getAll() {
        return Collections.unmodifiableList(GLOSSARY_RENDERERS);
    }

    public static void addGlossaryRenderer(IGlossaryRenderer renderer) {
        GLOSSARY_RENDERERS.add(renderer);
    }

    public static void setPreferredGlossaryRenderer(IGlossaryRenderer renderer) {
        Preferences.setPreference("glossary_layout", renderer.getId());
        preferred = renderer;
    }

    public static IGlossaryRenderer getPreferredGlossaryRenderer() {
        if (preferred == null) {
            String preferredId = Preferences.getPreferenceDefault("glossary_layout", DEFAULT_RENDERER.getId());
            for (IGlossaryRenderer renderer : GLOSSARY_RENDERERS) {
                if (!renderer.getId().equals(preferredId)) continue;
                preferred = renderer;
            }
            if (preferred == null) {
                preferred = DEFAULT_RENDERER;
            }
        }
        return preferred;
    }

    static {
        GlossaryRenderers.addGlossaryRenderer(DEFAULT_RENDERER);
        GlossaryRenderers.addGlossaryRenderer(new DictionaryGlossaryRenderer());
        preferred = null;
    }
}

