/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.DictZipOutputStream;
import org.dict.zip.RandomAccessInputStream;
import org.dict.zip.RandomAccessOutputStream;

public class DictZipFiles {
    static final int CHECK_BUF_LEN = 65536;

    public static DictZipInputStream newDictZipInputStream(Path path) throws IOException {
        return new DictZipInputStream(DictZipFiles.newRandomAccessInputStream(path));
    }

    public static DictZipOutputStream newDictZipOutputStream(Path path, long dataSize) throws IOException {
        return new DictZipOutputStream(DictZipFiles.newRandomAccessOutputStream(path), dataSize);
    }

    public static RandomAccessInputStream newRandomAccessInputStream(Path path) throws IOException {
        return new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"));
    }

    public static RandomAccessOutputStream newRandomAccessOutputStream(Path path) throws IOException {
        return new RandomAccessOutputStream(new RandomAccessFile(path.toFile(), "w"));
    }

    public static boolean checkDictZipFile(Path path) throws IOException {
        try (DictZipInputStream dzin = new DictZipInputStream(DictZipFiles.newRandomAccessInputStream(path));){
            boolean bl = DictZipFiles.checkDictZipInputStream(dzin);
            return bl;
        }
    }

    public static boolean checkDictZipFile(String filename) throws IOException {
        try (DictZipInputStream dzin = DictZipFiles.newDictZipInputStream(Paths.get(filename, new String[0]));){
            boolean bl = DictZipFiles.checkDictZipInputStream(dzin);
            return bl;
        }
    }

    public static boolean checkDictZipInputStream(DictZipInputStream in) throws IOException {
        long readLen;
        int len;
        byte[] tmpBuf = new byte[65536];
        in.seek(0L);
        for (readLen = 0L; readLen < in.getLength() && (len = in.read(tmpBuf, 0, 65536)) >= 0; readLen += (long)len) {
        }
        return readLen == in.getLength();
    }
}

