/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.PackageError;
import org.armedbear.lisp.Packages;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;

public final class Package
extends LispObject
implements Serializable {
    private String name;
    private transient SimpleString lispName;
    private transient LispObject propertyList;
    private final transient ConcurrentHashMap<String, Symbol> internalSymbols = new ConcurrentHashMap(16);
    private final transient ConcurrentHashMap<String, Symbol> externalSymbols = new ConcurrentHashMap(16);
    private transient HashMap<String, Symbol> shadowingSymbols;
    private transient ArrayList<String> nicknames;
    private transient LispObject useList = null;
    private transient ArrayList<Package> usedByList = null;
    private transient ConcurrentHashMap<String, Package> localNicknames;

    public Package() {
    }

    public Package(String name) {
        this.name = name;
        this.lispName = new SimpleString(name);
    }

    public Package(String name, int size) {
        this.name = name;
        this.lispName = new SimpleString(name);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.PACKAGE;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.PACKAGE;
    }

    @Override
    public LispObject getDescription() {
        if (this.name != null) {
            StringBuilder sb = new StringBuilder("The ");
            sb.append(this.name);
            sb.append(" package");
            return new SimpleString(sb);
        }
        return new SimpleString("PACKAGE");
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.PACKAGE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.PACKAGE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public final String getName() {
        return this.name;
    }

    public final LispObject NAME() {
        return this.lispName != null ? this.lispName : Lisp.NIL;
    }

    @Override
    public final LispObject getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = Lisp.NIL;
        }
        return this.propertyList;
    }

    @Override
    public final void setPropertyList(LispObject obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        this.propertyList = obj;
    }

    public final List getNicknames() {
        return this.nicknames;
    }

    private void makeSymbolsUninterned(ConcurrentHashMap symbolMap) {
        for (Symbol sym : symbolMap.values()) {
            if (sym.getPackage() != this) continue;
            sym.setPackage(Lisp.NIL);
        }
        symbolMap.clear();
    }

    public final synchronized boolean delete() {
        if (this.name != null) {
            if (this.useList instanceof Cons) {
                for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                    Package pkg = (Package)usedPackages.car();
                    this.unusePackage(pkg);
                }
            }
            if (this.usedByList != null) {
                while (!this.usedByList.isEmpty()) {
                    this.usedByList.get(0).unusePackage(this);
                }
            }
            LispObject packages = Packages.getPackagesNicknamingPackage(this);
            while (packages != Lisp.NIL) {
                Package p = (Package)((Cons)packages).car();
                packages = ((Cons)packages).cdr();
                p.removeLocalPackageNicknamesForPackage(this);
            }
            Packages.deletePackage(this);
            this.makeSymbolsUninterned(this.internalSymbols);
            this.makeSymbolsUninterned(this.externalSymbols);
            this.name = null;
            this.lispName = null;
            this.nicknames = null;
            return true;
        }
        return false;
    }

    public final synchronized void rename(String newName, LispObject newNicks) {
        ArrayList<String> arrayList = null;
        while (newNicks != Lisp.NIL) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(Lisp.javaString(newNicks.car()));
            newNicks = newNicks.cdr();
        }
        Packages.deletePackage(this);
        this.name = newName;
        this.lispName = new SimpleString(newName);
        this.nicknames = arrayList;
        Packages.addPackage(this);
    }

    public Symbol findInternalSymbol(SimpleString name) {
        return this.internalSymbols.get(name.toString());
    }

    public Symbol findInternalSymbol(String name) {
        return this.internalSymbols.get(name);
    }

    public Symbol findExternalSymbol(SimpleString name) {
        return this.externalSymbols.get(name.toString());
    }

    public Symbol findExternalSymbol(String name) {
        return this.externalSymbols.get(name);
    }

    public Symbol findExternalSymbol(SimpleString name, int hash) {
        return this.externalSymbols.get(name.toString());
    }

    public Symbol findAccessibleSymbol(String name) {
        return this.findAccessibleSymbol(new SimpleString(name));
    }

    public Symbol findAccessibleSymbol(SimpleString name) {
        Symbol symbol = this.externalSymbols.get(name.toString());
        if (symbol != null) {
            return symbol;
        }
        symbol = this.internalSymbols.get(name.toString());
        if (symbol != null) {
            return symbol;
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(name);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return null;
    }

    public LispObject findSymbol(String name) {
        SimpleString s = new SimpleString(name);
        LispThread thread = LispThread.currentThread();
        Symbol symbol = this.externalSymbols.get(name);
        if (symbol != null) {
            return thread.setValues(symbol, Keyword.EXTERNAL);
        }
        symbol = this.internalSymbols.get(name);
        if (symbol != null) {
            return thread.setValues(symbol, Keyword.INTERNAL);
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(s);
                if (symbol == null) continue;
                return thread.setValues(symbol, Keyword.INHERITED);
            }
        }
        return thread.setValues(Lisp.NIL, Lisp.NIL);
    }

    public void addSymbol(Symbol symbol) {
        Debug.assertTrue(symbol.getPackage() == this);
        Debug.assertTrue(symbol.getName().equals("NIL"));
        this.externalSymbols.put(symbol.name.toString(), symbol);
    }

    private Symbol addSymbol(String name) {
        Symbol symbol = new Symbol(name, this);
        if (this == Lisp.PACKAGE_KEYWORD) {
            symbol.initializeConstant(symbol);
            this.externalSymbols.put(name.toString(), symbol);
        } else {
            this.internalSymbols.put(name.toString(), symbol);
        }
        return symbol;
    }

    private Symbol addSymbol(SimpleString name) {
        return this.addSymbol(name.toString());
    }

    public Symbol addInternalSymbol(String symbolName) {
        Symbol symbol = new Symbol(symbolName, this);
        this.internalSymbols.put(symbolName, symbol);
        return symbol;
    }

    public Symbol addExternalSymbol(String symbolName) {
        Symbol symbol = new Symbol(symbolName, this);
        this.externalSymbols.put(symbolName, symbol);
        return symbol;
    }

    public synchronized Symbol intern(SimpleString symbolName) {
        return this.intern(symbolName.toString());
    }

    public synchronized Symbol intern(String symbolName) {
        Symbol symbol = this.externalSymbols.get(symbolName);
        if (symbol != null) {
            return symbol;
        }
        symbol = this.internalSymbols.get(symbolName);
        if (symbol != null) {
            return symbol;
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.externalSymbols.get(symbolName);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return this.addSymbol(symbolName);
    }

    public synchronized Symbol intern(SimpleString s, LispThread thread) {
        Symbol symbol = this.externalSymbols.get(s.toString());
        if (symbol != null) {
            return (Symbol)thread.setValues(symbol, Keyword.EXTERNAL);
        }
        symbol = this.internalSymbols.get(s.toString());
        if (symbol != null) {
            return (Symbol)thread.setValues(symbol, Keyword.INTERNAL);
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(s);
                if (symbol == null) continue;
                return (Symbol)thread.setValues(symbol, Keyword.INHERITED);
            }
        }
        return (Symbol)thread.setValues(this.addSymbol(s), Lisp.NIL);
    }

    public synchronized Symbol internAndExport(String symbolName) {
        SimpleString s = new SimpleString(symbolName);
        Symbol symbol = this.externalSymbols.get(s.toString());
        if (symbol != null) {
            return symbol;
        }
        symbol = this.internalSymbols.get(s.toString());
        if (symbol != null) {
            this.export(symbol);
            return symbol;
        }
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                symbol = pkg.findExternalSymbol(s);
                if (symbol == null) continue;
                this.export(symbol);
                return symbol;
            }
        }
        symbol = new Symbol(s, this);
        if (this == Lisp.PACKAGE_KEYWORD) {
            symbol.initializeConstant(symbol);
        }
        this.externalSymbols.put(s.toString(), symbol);
        return symbol;
    }

    public synchronized LispObject unintern(Symbol symbol) {
        String symbolName = symbol.getName();
        boolean shadow = this.shadowingSymbols != null && this.shadowingSymbols.get(symbolName) == symbol;
        if (shadow) {
            Symbol sym = null;
            if (this.useList instanceof Cons) {
                for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                    Package pkg = (Package)usedPackages.car();
                    Symbol s = pkg.findExternalSymbol(symbol.name);
                    if (s == null) continue;
                    if (sym == null) {
                        sym = s;
                        continue;
                    }
                    if (sym == s) continue;
                    StringBuilder sb = new StringBuilder("Uninterning the symbol ");
                    sb.append(symbol.getQualifiedName());
                    sb.append(" causes a name conflict between ");
                    sb.append(sym.getQualifiedName());
                    sb.append(" and ");
                    sb.append(s.getQualifiedName());
                    return Lisp.error(new PackageError(sb.toString(), this));
                }
            }
        }
        boolean found = false;
        if (this.externalSymbols.get(symbol.name.toString()) == symbol) {
            this.externalSymbols.remove(symbol.name.toString());
            found = true;
        }
        if (this.internalSymbols.get(symbol.name.toString()) == symbol) {
            this.internalSymbols.remove(symbol.name.toString());
            found = true;
        }
        if (!found) {
            return Lisp.NIL;
        }
        if (shadow) {
            Debug.assertTrue(this.shadowingSymbols != null);
            this.shadowingSymbols.remove(symbolName);
        }
        if (symbol.getPackage() == this) {
            symbol.setPackage(Lisp.NIL);
        }
        return Lisp.T;
    }

    public synchronized void importSymbol(Symbol symbol) {
        if (symbol.getPackage() == this) {
            return;
        }
        Symbol sym = this.findAccessibleSymbol(symbol.name);
        if (sym != null && sym != symbol) {
            StringBuilder sb = new StringBuilder("The symbol ");
            sb.append(sym.getQualifiedName());
            sb.append(" is already accessible in package ");
            sb.append(this.name);
            sb.append('.');
            Lisp.error(new PackageError(sb.toString(), this));
        }
        this.internalSymbols.put(symbol.name.toString(), symbol);
        if (symbol.getPackage() == Lisp.NIL) {
            symbol.setPackage(this);
        }
    }

    public synchronized void export(Symbol symbol) {
        String symbolName = symbol.getName();
        boolean added = false;
        if (symbol.getPackage() != this) {
            Symbol sym = this.findAccessibleSymbol(symbol.name);
            if (sym != symbol) {
                StringBuilder sb = new StringBuilder("The symbol ");
                sb.append(symbol.getQualifiedName());
                sb.append(" is not accessible in package ");
                sb.append(this.name);
                sb.append('.');
                Lisp.error(new PackageError(sb.toString(), this));
                return;
            }
            this.internalSymbols.put(symbol.name.toString(), symbol);
            added = true;
        }
        if (added || this.internalSymbols.get(symbol.name.toString()) == symbol) {
            if (this.usedByList != null) {
                for (Package pkg : this.usedByList) {
                    Symbol sym = pkg.findAccessibleSymbol(symbol.name);
                    if (sym == null || sym == symbol || pkg.shadowingSymbols != null && pkg.shadowingSymbols.get(symbolName) == sym) continue;
                    StringBuilder sb = new StringBuilder("The symbol ");
                    sb.append(sym.getQualifiedName());
                    sb.append(" is already accessible in package ");
                    sb.append(pkg.getName());
                    sb.append('.');
                    Lisp.error(new PackageError(sb.toString(), pkg));
                    return;
                }
            }
            this.internalSymbols.remove(symbol.name.toString());
            this.externalSymbols.put(symbol.name.toString(), symbol);
            return;
        }
        if (this.externalSymbols.get(symbol.name.toString()) == symbol) {
            return;
        }
        StringBuilder sb = new StringBuilder("The symbol ");
        sb.append(symbol.getQualifiedName());
        sb.append(" is not accessible in package ");
        sb.append(this.name);
        sb.append('.');
        Lisp.error(new PackageError(sb.toString(), this));
    }

    public synchronized void unexport(Symbol symbol) {
        if (this.externalSymbols.get(symbol.name.toString()) == symbol) {
            this.externalSymbols.remove(symbol.name.toString());
            this.internalSymbols.put(symbol.name.toString(), symbol);
        } else if (this.findAccessibleSymbol(symbol.name.toString()) != symbol) {
            StringBuilder sb = new StringBuilder("The symbol ");
            sb.append(symbol.getQualifiedName());
            sb.append(" is not accessible in package ");
            sb.append(this.name);
            Lisp.error(new PackageError(sb.toString(), this));
        }
    }

    public synchronized void shadow(String symbolName) {
        SimpleString s;
        Symbol symbol;
        if (this.shadowingSymbols == null) {
            this.shadowingSymbols = new HashMap();
        }
        if ((symbol = this.externalSymbols.get((s = new SimpleString(symbolName)).toString())) != null) {
            this.shadowingSymbols.put(symbolName, symbol);
            return;
        }
        symbol = this.internalSymbols.get(s.toString());
        if (symbol != null) {
            this.shadowingSymbols.put(symbolName, symbol);
            return;
        }
        if (this.shadowingSymbols.get(symbolName) != null) {
            return;
        }
        symbol = new Symbol(s, this);
        this.internalSymbols.put(s.toString(), symbol);
        this.shadowingSymbols.put(symbolName, symbol);
    }

    public synchronized void shadowingImport(Symbol symbol) {
        String symbolName = symbol.getName();
        Symbol sym = this.externalSymbols.get(symbolName);
        if (sym == null) {
            sym = this.internalSymbols.get(symbol.name.toString());
        }
        if (sym != null && sym != symbol) {
            if (this.shadowingSymbols != null) {
                this.shadowingSymbols.remove(symbolName);
            }
            this.unintern(sym);
        }
        if (sym == null || sym != symbol) {
            this.internalSymbols.put(symbol.name.toString(), symbol);
        }
        if (this.shadowingSymbols == null) {
            this.shadowingSymbols = new HashMap();
        }
        this.shadowingSymbols.put(symbolName, symbol);
    }

    public void usePackage(Package pkg) {
        if (this.useList == null) {
            this.useList = Lisp.NIL;
        }
        if (!Lisp.memq(pkg, this.useList)) {
            Collection symbols = pkg.getExternalSymbols();
            for (Symbol symbol : symbols) {
                Symbol existing = this.findAccessibleSymbol(symbol.name);
                if (existing == null || existing == symbol || this.shadowingSymbols != null && this.shadowingSymbols.get(symbol.getName()) != null) continue;
                Lisp.error(new PackageError("A symbol named " + symbol.getName() + " is already accessible in package " + this.name + ".", this));
                return;
            }
            this.useList = this.useList.push(pkg);
            if (pkg.usedByList != null) {
                Debug.assertTrue(!pkg.usedByList.contains(this));
            }
            if (pkg.usedByList == null) {
                pkg.usedByList = new ArrayList();
            }
            pkg.usedByList.add(this);
        }
    }

    public void unusePackage(Package pkg) {
        if (this.useList instanceof Cons && Lisp.memq(pkg, this.useList)) {
            LispObject newList = Lisp.NIL;
            while (this.useList != Lisp.NIL) {
                if (this.useList.car() != pkg) {
                    newList = newList.push(this.useList.car());
                }
                this.useList = this.useList.cdr();
            }
            this.useList = newList.nreverse();
            Debug.assertTrue(!Lisp.memq(pkg, this.useList));
            Debug.assertTrue(pkg.usedByList != null);
            Debug.assertTrue(pkg.usedByList.contains(this));
            pkg.usedByList.remove(this);
        }
    }

    public final void addNickname(String s) {
        Packages.addNickname(this, s);
        if (this.nicknames != null) {
            if (this.nicknames.contains(s)) {
                return;
            }
        } else {
            this.nicknames = new ArrayList();
        }
        this.nicknames.add(s);
    }

    public String getNickname() {
        if (this.nicknames != null && this.nicknames.size() > 0) {
            return this.nicknames.get(0);
        }
        return null;
    }

    public LispObject packageNicknames() {
        LispObject list = Lisp.NIL;
        if (this.nicknames != null) {
            int i = this.nicknames.size();
            while (i-- > 0) {
                String nickname = this.nicknames.get(i);
                list = new Cons(new SimpleString(nickname), list);
            }
        }
        return list;
    }

    public LispObject getUseList() {
        if (this.useList == null) {
            this.useList = Lisp.NIL;
        }
        return this.useList;
    }

    public boolean uses(LispObject pkg) {
        return this.useList instanceof Cons && Lisp.memq(pkg, this.useList);
    }

    public LispObject getUsedByList() {
        LispObject list = Lisp.NIL;
        if (this.usedByList != null) {
            for (Package pkg : this.usedByList) {
                list = new Cons(pkg, list);
            }
        }
        return list;
    }

    public LispObject getLocalPackageNicknames() {
        LispObject list = Lisp.NIL;
        if (this.localNicknames != null) {
            for (Map.Entry<String, Package> entry : this.localNicknames.entrySet()) {
                list = new Cons(new Cons(entry.getKey(), (LispObject)entry.getValue()), list);
            }
        }
        return list;
    }

    public LispObject addLocalPackageNickname(String name, Package pack) {
        if (this.localNicknames == null) {
            this.localNicknames = new ConcurrentHashMap();
        }
        if (this.localNicknames.containsKey(name)) {
            if (this.localNicknames.get(name) != pack) {
                return Lisp.error(new LispError(name + " is already a nickname for " + pack.getName()));
            }
            return this;
        }
        this.localNicknames.put(name, pack);
        return this;
    }

    public LispObject removeLocalPackageNickname(String name) {
        if (this.localNicknames == null || !this.localNicknames.containsKey(name)) {
            return Lisp.NIL;
        }
        return this.localNicknames.remove(name);
    }

    public void removeLocalPackageNicknamesForPackage(Package p) {
        if (this.localNicknames == null || !this.localNicknames.containsValue(p)) {
            return;
        }
        for (Map.Entry<String, Package> entry : this.localNicknames.entrySet()) {
            if (entry.getValue() != p) continue;
            this.localNicknames.remove(entry.getKey());
        }
    }

    public Collection<Package> getLocallyNicknamedPackages() {
        if (this.localNicknames == null) {
            return new ArrayList<Package>();
        }
        return this.localNicknames.values();
    }

    public Package findPackage(String name) {
        Package pkg;
        if (this.localNicknames != null && (pkg = this.localNicknames.get(name)) != null) {
            return pkg;
        }
        return Packages.findPackageGlobally(name);
    }

    public LispObject getShadowingSymbols() {
        LispObject list = Lisp.NIL;
        if (this.shadowingSymbols != null) {
            for (Symbol symbol : this.shadowingSymbols.values()) {
                list = new Cons(symbol, list);
            }
        }
        return list;
    }

    public synchronized Collection getExternalSymbols() {
        return this.externalSymbols.values();
    }

    public synchronized List<Symbol> getAccessibleSymbols() {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        list.addAll(this.internalSymbols.values());
        list.addAll(this.externalSymbols.values());
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                list.addAll(pkg.externalSymbols.values());
            }
        }
        return list;
    }

    public synchronized LispObject PACKAGE_INTERNAL_SYMBOLS() {
        LispObject list = Lisp.NIL;
        Collection<Symbol> symbols = this.internalSymbols.values();
        Iterator<Symbol> i = symbols.iterator();
        while (i.hasNext()) {
            list = new Cons(i.next(), list);
        }
        return list;
    }

    public synchronized LispObject PACKAGE_EXTERNAL_SYMBOLS() {
        LispObject list = Lisp.NIL;
        Collection<Symbol> symbols = this.externalSymbols.values();
        Iterator<Symbol> i = symbols.iterator();
        while (i.hasNext()) {
            list = new Cons(i.next(), list);
        }
        return list;
    }

    public synchronized LispObject PACKAGE_INHERITED_SYMBOLS() {
        LispObject list = Lisp.NIL;
        if (this.useList instanceof Cons) {
            for (LispObject usedPackages = this.useList; usedPackages != Lisp.NIL; usedPackages = usedPackages.cdr()) {
                Package pkg = (Package)usedPackages.car();
                Collection externals = pkg.getExternalSymbols();
                for (Symbol symbol : externals) {
                    if (this.shadowingSymbols != null && this.shadowingSymbols.get(symbol.getName()) != null || this.externalSymbols.get(symbol.name.toString()) == symbol) continue;
                    list = new Cons(symbol, list);
                }
            }
        }
        return list;
    }

    public synchronized LispObject getSymbols() {
        LispObject list = Lisp.NIL;
        Collection<Symbol> internals = this.internalSymbols.values();
        Iterator<Symbol> i = internals.iterator();
        while (i.hasNext()) {
            list = new Cons(i.next(), list);
        }
        Collection<Symbol> externals = this.externalSymbols.values();
        Iterator<Symbol> i2 = externals.iterator();
        while (i2.hasNext()) {
            list = new Cons(i2.next(), list);
        }
        return list;
    }

    public synchronized Symbol[] symbols() {
        Collection<Symbol> internals = this.internalSymbols.values();
        Collection<Symbol> externals = this.externalSymbols.values();
        Symbol[] array = new Symbol[internals.size() + externals.size()];
        int i = 0;
        for (Symbol symbol : internals) {
            array[i++] = symbol;
        }
        for (Symbol symbol : externals) {
            array[i++] = symbol;
        }
        return array;
    }

    @Override
    public String printObject() {
        if (Lisp._PRINT_FASL_.symbolValue() != Lisp.NIL && this.name != null) {
            StringBuilder sb = new StringBuilder("#.(CL:FIND-PACKAGE \"");
            sb.append(this.name);
            sb.append("\")");
            return sb.toString();
        }
        if (this.name != null) {
            return this.unreadableString("PACKAGE " + this.name, false);
        }
        return this.unreadableString("PACKAGE");
    }

    public Object readResolve() throws ObjectStreamException {
        Package pkg = this.findPackage(this.name);
        if (pkg != null) {
            return pkg;
        }
        return Lisp.error(new PackageError(this.name + " is not the name of a package.", new SimpleString(this.name)));
    }
}

