/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.naming.ContextBindings;
import org.apache.naming.NamingContext;
import org.apache.naming.StringManager;

public class SelectorContext
implements Context {
    public static final String prefix = "java:";
    public static final int prefixLength = "java:".length();
    public static final String IC_PREFIX = "IC_";
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager((String)"org.apache.naming");
    protected boolean initialContext = false;

    public SelectorContext(Hashtable env) {
        this.env = env;
    }

    public SelectorContext(Hashtable env, boolean initialContext) {
        this(env);
        this.initialContext = initialContext;
    }

    public Object lookup(Name name) throws NamingException {
        return this.getBoundContext().lookup(this.parseName(name));
    }

    public Object lookup(String name) throws NamingException {
        return this.getBoundContext().lookup(this.parseName(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.getBoundContext().bind(this.parseName(name), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.getBoundContext().bind(this.parseName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.getBoundContext().rebind(this.parseName(name), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.getBoundContext().rebind(this.parseName(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        this.getBoundContext().unbind(this.parseName(name));
    }

    public void unbind(String name) throws NamingException {
        this.getBoundContext().unbind(this.parseName(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.getBoundContext().rename(this.parseName(oldName), this.parseName(newName));
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.getBoundContext().rename(this.parseName(oldName), this.parseName(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getBoundContext().list(this.parseName(name));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.getBoundContext().list(this.parseName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getBoundContext().listBindings(this.parseName(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.getBoundContext().listBindings(this.parseName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(name));
    }

    public void destroySubcontext(String name) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(name));
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.getBoundContext().lookupLink(this.parseName(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.getBoundContext().lookupLink(this.parseName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(name));
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(name));
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)prefix.clone();
        return prefix.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.getBoundContext().addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.getBoundContext().removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.getBoundContext().getEnvironment();
    }

    public void close() throws NamingException {
        this.getBoundContext().close();
    }

    public String getNameInNamespace() throws NamingException {
        return prefix;
    }

    protected Context getBoundContext() throws NamingException {
        if (this.initialContext) {
            String ICName = IC_PREFIX;
            if (ContextBindings.isThreadBound()) {
                ICName = ICName + ContextBindings.getThreadName();
            } else if (ContextBindings.isClassLoaderBound()) {
                ICName = ICName + ContextBindings.getClassLoaderName();
            }
            Context initialContext = ContextBindings.getContext(ICName);
            if (initialContext == null) {
                initialContext = new NamingContext(this.env, ICName);
                ContextBindings.bindContext(ICName, initialContext);
            }
            return initialContext;
        }
        if (ContextBindings.isThreadBound()) {
            return ContextBindings.getThread();
        }
        return ContextBindings.getClassLoader();
    }

    protected String parseName(String name) throws NamingException {
        if (!this.initialContext && name.startsWith(prefix)) {
            return name.substring(prefixLength);
        }
        if (this.initialContext) {
            return name;
        }
        throw new NamingException(this.sm.getString("selectorContext.noJavaUrl"));
    }

    protected Name parseName(Name name) throws NamingException {
        if (!this.initialContext && !name.isEmpty() && name.get(0).equals(prefix)) {
            return name.getSuffix(1);
        }
        if (this.initialContext) {
            return name;
        }
        throw new NamingException(this.sm.getString("selectorContext.noJavaUrl"));
    }
}

