/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.LifetimeExceededException;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class PoolableConnectionFactory
implements PooledObjectFactory<PoolableConnection> {
    private static final Log log = LogFactory.getLog(PoolableConnectionFactory.class);
    private final ConnectionFactory connectionFactory;
    private final ObjectName dataSourceJmxObjectName;
    private volatile String validationQuery;
    private volatile int validationQueryTimeoutSeconds = -1;
    private Collection<String> connectionInitSqls;
    private Collection<String> disconnectionSqlCodes;
    private boolean fastFailValidation;
    private volatile ObjectPool<PoolableConnection> pool;
    private Boolean defaultReadOnly;
    private Boolean defaultAutoCommit;
    private boolean enableAutoCommitOnReturn = true;
    private boolean rollbackOnReturn = true;
    private int defaultTransactionIsolation = -1;
    private String defaultCatalog;
    private boolean cacheState;
    private boolean poolStatements;
    private int maxOpenPreparedStatements = 8;
    private long maxConnLifetimeMillis = -1L;
    private final AtomicLong connectionIndex = new AtomicLong(0L);
    private Integer defaultQueryTimeoutSeconds;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectName dataSourceJmxObjectName) {
        this.connectionFactory = connFactory;
        this.dataSourceJmxObjectName = dataSourceJmxObjectName;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setValidationQueryTimeout(int validationQueryTimeoutSeconds) {
        this.validationQueryTimeoutSeconds = validationQueryTimeoutSeconds;
    }

    public void setConnectionInitSql(Collection<String> connectionInitSqls) {
        this.connectionInitSqls = connectionInitSqls;
    }

    public synchronized void setPool(ObjectPool<PoolableConnection> pool) {
        if (null != this.pool && pool != this.pool) {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pool = pool;
    }

    public synchronized ObjectPool<PoolableConnection> getPool() {
        return this.pool;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public void setCacheState(boolean cacheState) {
        this.cacheState = cacheState;
    }

    public void setPoolStatements(boolean poolStatements) {
        this.poolStatements = poolStatements;
    }

    @Deprecated
    public void setMaxOpenPrepatedStatements(int maxOpenPreparedStatements) {
        this.setMaxOpenPreparedStatements(maxOpenPreparedStatements);
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    public boolean isEnableAutoCommitOnReturn() {
        return this.enableAutoCommitOnReturn;
    }

    public void setEnableAutoCommitOnReturn(boolean enableAutoCommitOnReturn) {
        this.enableAutoCommitOnReturn = enableAutoCommitOnReturn;
    }

    public boolean isRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeoutSeconds;
    }

    public void setDefaultQueryTimeout(Integer defaultQueryTimeoutSeconds) {
        this.defaultQueryTimeoutSeconds = defaultQueryTimeoutSeconds;
    }

    public Collection<String> getDisconnectionSqlCodes() {
        return this.disconnectionSqlCodes;
    }

    public void setDisconnectionSqlCodes(Collection<String> disconnectionSqlCodes) {
        this.disconnectionSqlCodes = disconnectionSqlCodes;
    }

    public boolean isFastFailValidation() {
        return this.fastFailValidation;
    }

    public void setFastFailValidation(boolean fastFailValidation) {
        this.fastFailValidation = fastFailValidation;
    }

    @Override
    public PooledObject<PoolableConnection> makeObject() throws Exception {
        Connection conn = this.connectionFactory.createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        try {
            this.initializeConnection(conn);
        }
        catch (SQLException sqle) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw sqle;
        }
        long connIndex = this.connectionIndex.getAndIncrement();
        if (this.poolStatements) {
            conn = new PoolingConnection(conn);
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(-1);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(1);
            config.setMaxTotal(this.maxOpenPreparedStatements);
            if (this.dataSourceJmxObjectName != null) {
                StringBuilder base = new StringBuilder(this.dataSourceJmxObjectName.toString());
                base.append(",connectionpool=connections,connection=");
                base.append(Long.toString(connIndex));
                config.setJmxNameBase(base.toString());
                config.setJmxNamePrefix(",statementpool=statements");
            } else {
                config.setJmxEnabled(false);
            }
            GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> stmtPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>((PoolingConnection)conn, config);
            ((PoolingConnection)conn).setStatementPool(stmtPool);
            ((PoolingConnection)conn).setCacheState(this.cacheState);
        }
        ObjectName connJmxName = this.dataSourceJmxObjectName == null ? null : new ObjectName(this.dataSourceJmxObjectName.toString() + ",connectionpool=connections,connection=" + connIndex);
        PoolableConnection pc = new PoolableConnection(conn, this.pool, connJmxName, this.disconnectionSqlCodes, this.fastFailValidation);
        pc.setCacheState(this.cacheState);
        return new DefaultPooledObject<PoolableConnection>(pc);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        Collection<String> sqls = this.connectionInitSqls;
        if (conn.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (null != sqls) {
            try (Statement stmt = conn.createStatement();){
                for (String sql : sqls) {
                    Objects.requireNonNull(sql, "null connectionInitSqls element");
                    stmt.execute(sql);
                }
            }
        }
    }

    @Override
    public void destroyObject(PooledObject<PoolableConnection> p) throws Exception {
        p.getObject().reallyClose();
    }

    @Override
    public boolean validateObject(PooledObject<PoolableConnection> p) {
        try {
            this.validateLifetime(p);
            this.validateConnection(p.getObject());
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Utils.getMessage("poolableConnectionFactory.validateObject.fail"), (Throwable)e);
            }
            return false;
        }
    }

    public void validateConnection(PoolableConnection conn) throws SQLException {
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        conn.validate(this.validationQuery, this.validationQueryTimeoutSeconds);
    }

    @Override
    public void passivateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        Boolean connAutoCommit = null;
        if (this.rollbackOnReturn && !(connAutoCommit = Boolean.valueOf(conn.getAutoCommit())).booleanValue() && !conn.isReadOnly()) {
            conn.rollback();
        }
        conn.clearWarnings();
        if (this.enableAutoCommitOnReturn) {
            if (connAutoCommit == null) {
                connAutoCommit = conn.getAutoCommit();
            }
            if (!connAutoCommit.booleanValue()) {
                conn.setAutoCommit(true);
            }
        }
        conn.passivate();
    }

    @Override
    public void activateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        conn.activate();
        if (this.defaultAutoCommit != null && conn.getAutoCommit() != this.defaultAutoCommit.booleanValue()) {
            conn.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.defaultTransactionIsolation != -1 && conn.getTransactionIsolation() != this.defaultTransactionIsolation) {
            conn.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.defaultReadOnly != null && conn.isReadOnly() != this.defaultReadOnly.booleanValue()) {
            conn.setReadOnly(this.defaultReadOnly);
        }
        if (this.defaultCatalog != null && !this.defaultCatalog.equals(conn.getCatalog())) {
            conn.setCatalog(this.defaultCatalog);
        }
        conn.setDefaultQueryTimeout(this.defaultQueryTimeoutSeconds);
    }

    private void validateLifetime(PooledObject<PoolableConnection> p) throws Exception {
        long lifetime;
        if (this.maxConnLifetimeMillis > 0L && (lifetime = System.currentTimeMillis() - p.getCreateTime()) > this.maxConnLifetimeMillis) {
            throw new LifetimeExceededException(Utils.getMessage("connectionFactory.lifetimeExceeded", lifetime, this.maxConnLifetimeMillis));
        }
    }

    protected ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected boolean getPoolStatements() {
        return this.poolStatements;
    }

    protected int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    protected boolean getCacheState() {
        return this.cacheState;
    }

    protected ObjectName getDataSourceJmxName() {
        return this.dataSourceJmxObjectName;
    }

    protected AtomicLong getConnectionIndex() {
        return this.connectionIndex;
    }
}

