/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.command.Command;
import org.apache.activemq.apollo.openwire.command.MarshallAware;
import org.apache.activemq.apollo.openwire.support.MarshallingSupport;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireFormatInfo
implements Command,
MarshallAware {
    public static final byte DATA_STRUCTURE_TYPE = 1;
    private static final int MAX_PROPERTY_SIZE = 4096;
    private static final byte[] MAGIC = new byte[]{65, 99, 116, 105, 118, 101, 77, 81};
    protected byte[] magic = MAGIC;
    protected int version;
    protected Buffer marshalledProperties;
    protected transient Map<String, Object> properties;

    @Override
    public byte getDataStructureType() {
        return 1;
    }

    @Override
    public boolean isWireFormatInfo() {
        return true;
    }

    @Override
    public boolean isMarshallAware() {
        return true;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public void setMagic(byte[] magic) {
        this.magic = magic;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Buffer getMarshalledProperties() {
        return this.marshalledProperties;
    }

    public void setMarshalledProperties(Buffer marshalledProperties) {
        this.marshalledProperties = marshalledProperties;
    }

    public Object getProperty(String name) throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return null;
            }
            this.properties = this.unmarsallProperties(this.marshalledProperties);
        }
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return Collections.EMPTY_MAP;
            }
            this.properties = this.unmarsallProperties(this.marshalledProperties);
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public void clearProperties() {
        this.marshalledProperties = null;
        this.properties = null;
    }

    public void setProperty(String name, Object value) throws IOException {
        this.lazyCreateProperties();
        this.properties.put(name, value);
    }

    protected void lazyCreateProperties() throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                this.properties = new HashMap<String, Object>();
            } else {
                this.properties = this.unmarsallProperties(this.marshalledProperties);
                this.marshalledProperties = null;
            }
        }
    }

    private Map<String, Object> unmarsallProperties(Buffer marshalledProperties) throws IOException {
        return MarshallingSupport.unmarshalPrimitiveMap(new DataInputStream((InputStream)new ByteArrayInputStream(marshalledProperties)), 4096);
    }

    @Override
    public void beforeMarshall(OpenWireFormat wireFormat) throws IOException {
        if (this.marshalledProperties == null && this.properties != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream((OutputStream)baos);
            MarshallingSupport.marshalPrimitiveMap(this.properties, os);
            os.close();
            this.marshalledProperties = baos.toBuffer();
        }
    }

    @Override
    public void afterMarshall(OpenWireFormat wireFormat) throws IOException {
    }

    @Override
    public void beforeUnmarshall(OpenWireFormat wireFormat) throws IOException {
    }

    @Override
    public void afterUnmarshall(OpenWireFormat wireFormat) throws IOException {
    }

    public boolean isValid() {
        return this.magic != null && Arrays.equals(this.magic, MAGIC);
    }

    @Override
    public void setResponseRequired(boolean responseRequired) {
    }

    public boolean isCacheEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("CacheEnabled");
    }

    public void setCacheEnabled(boolean cacheEnabled) throws IOException {
        this.setProperty("CacheEnabled", cacheEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isStackTraceEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("StackTraceEnabled");
    }

    public void setStackTraceEnabled(boolean stackTraceEnabled) throws IOException {
        this.setProperty("StackTraceEnabled", stackTraceEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTcpNoDelayEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("TcpNoDelayEnabled");
    }

    public void setTcpNoDelayEnabled(boolean tcpNoDelayEnabled) throws IOException {
        this.setProperty("TcpNoDelayEnabled", tcpNoDelayEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isSizePrefixDisabled() throws IOException {
        return Boolean.TRUE == this.getProperty("SizePrefixDisabled");
    }

    public void setSizePrefixDisabled(boolean prefixPacketSize) throws IOException {
        this.setProperty("SizePrefixDisabled", prefixPacketSize ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTightEncodingEnabled() throws IOException {
        return Boolean.TRUE == this.getProperty("TightEncodingEnabled");
    }

    public void setTightEncodingEnabled(boolean tightEncodingEnabled) throws IOException {
        this.setProperty("TightEncodingEnabled", tightEncodingEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public long getMaxInactivityDuration() throws IOException {
        Long l = (Long)this.getProperty("MaxInactivityDuration");
        return l == null ? 0L : l;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) throws IOException {
        this.setProperty("MaxInactivityDuration", new Long(maxInactivityDuration));
    }

    public long getMaxInactivityDurationInitalDelay() throws IOException {
        Long l = (Long)this.getProperty("MaxInactivityDurationInitalDelay");
        return l == null ? 0L : l;
    }

    public void setMaxInactivityDurationInitalDelay(long maxInactivityDurationInitalDelay) throws IOException {
        this.setProperty("MaxInactivityDurationInitalDelay", new Long(maxInactivityDurationInitalDelay));
    }

    public long getMaxFrameSize() throws IOException {
        Long l = (Long)this.getProperty("MaxFrameSize");
        return l == null ? 0L : l;
    }

    public void setMaxFrameSize(long maxFrameSize) throws IOException {
        this.setProperty("MaxFrameSize", new Long(maxFrameSize));
    }

    public int getCacheSize() throws IOException {
        Integer i = (Integer)this.getProperty("CacheSize");
        return i == null ? 0 : i;
    }

    public void setCacheSize(int cacheSize) throws IOException {
        this.setProperty("CacheSize", new Integer(cacheSize));
    }

    public String toString() {
        Map<String, Object> p = null;
        try {
            p = this.getProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "WireFormatInfo { version=" + this.version + ", properties=" + p + ", magic=" + this.toString(this.magic) + "}";
    }

    private String toString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append((char)data[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setCommandId(int value) {
    }

    @Override
    public int getCommandId() {
        return 0;
    }

    @Override
    public boolean isResponseRequired() {
        return false;
    }

    @Override
    public boolean isResponse() {
        return false;
    }

    @Override
    public boolean isBrokerInfo() {
        return false;
    }

    @Override
    public boolean isMessageDispatch() {
        return false;
    }

    @Override
    public boolean isMessage() {
        return false;
    }

    @Override
    public boolean isMessageAck() {
        return false;
    }

    @Override
    public boolean isMessageDispatchNotification() {
        return false;
    }

    @Override
    public boolean isShutdownInfo() {
        return false;
    }
}

