/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import ints.IntArray;
import ints.IntList;
import java.util.Arrays;
import java.util.stream.IntStream;

public class PbwtUpdater {
    private final int nHaps;
    private IntList[] a;

    public PbwtUpdater(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        int n3 = 4;
        this.nHaps = n2;
        this.a = (IntList[])IntStream.range(0, n3).mapToObj(n -> new IntList()).toArray(IntList[]::new);
    }

    public int nHaps() {
        return this.nHaps;
    }

    public void update(IntArray intArray, int n, int[] nArray) {
        if (intArray.size() != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(intArray.size()));
        }
        if (nArray.length != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        this.initializeArrays(n);
        for (int n2 : nArray) {
            int n3 = intArray.get(n2);
            if (n3 >= n) {
                throw new IndexOutOfBoundsException(String.valueOf(n3));
            }
            this.a[n3].add(n2);
        }
        this.updatePrefix(n, nArray);
    }

    public void update(int[] nArray, int n, int[] nArray2) {
        if (nArray.length != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (nArray2.length != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(nArray2.length));
        }
        this.initializeArrays(n);
        for (int n2 : nArray2) {
            int n3 = nArray[n2];
            if (n3 >= n) {
                throw new IndexOutOfBoundsException(String.valueOf(n3));
            }
            this.a[n3].add(n2);
        }
        this.updatePrefix(n, nArray2);
    }

    private void updatePrefix(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.a[i].size();
            System.arraycopy(this.a[i].toArray(), 0, nArray, n2, n3);
            n2 += n3;
            this.a[i].clear();
        }
        assert (n2 == this.nHaps);
    }

    private void initializeArrays(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.ensureArrayCapacity(n);
    }

    private void ensureArrayCapacity(int n) {
        if (n > this.a.length) {
            int n2 = this.a.length;
            this.a = Arrays.copyOf(this.a, n);
            for (int i = n2; i < this.a.length; ++i) {
                this.a[i] = new IntList();
            }
        }
    }
}

