/*
 * Decompiled with CFR 0.152.
 */
package ints;

import java.util.Arrays;
import java.util.stream.IntStream;

public class IntList {
    public static final int DEFAULT_INIT_CAPACITY = 16;
    private int size;
    private int[] values;

    public IntList() {
        this(16);
    }

    public IntList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.size = 0;
        this.values = new int[n];
    }

    public IntList(int[] nArray) {
        this.size = nArray.length;
        this.values = (int[])nArray.clone();
    }

    public IntList(IntList intList) {
        this.size = intList.size();
        this.values = Arrays.copyOf(intList.values, intList.size());
    }

    public void add(int n) {
        if (this.size == this.values.length) {
            int n2 = this.values.length * 3 / 2 + 1;
            this.values = Arrays.copyOf(this.values, n2);
        }
        this.values[this.size++] = n;
    }

    public int pop() {
        return this.values[--this.size];
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.values[n];
    }

    public int set(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = this.values[n];
        this.values[n] = n2;
        return n3;
    }

    public int getAndIncrement(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2];
        this.values[n2] = n3 + 1;
        return n3;
    }

    public int getAndDecrement(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2];
        this.values[n2] = n3 - 1;
        return n3;
    }

    public int incrementAndGet(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2] + 1;
        this.values[n2] = n3;
        return n3;
    }

    public int decrementAndGet(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2] - 1;
        this.values[n2] = n3;
        return n3;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.size);
    }

    public int binarySearch(int n) {
        return Arrays.binarySearch(this.values, 0, this.size, n);
    }

    public int[] copyOf(int n) {
        int[] nArray = Arrays.copyOf(this.values, n);
        if (n > this.size) {
            Arrays.fill(nArray, this.size, n, 0);
        }
        return nArray;
    }

    public int[] copyOfRange(int n, int n2) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int[] nArray = new int[n2 - n];
        if (n2 < this.size) {
            System.arraycopy(this.values, n, nArray, 0, n2 - n);
        } else {
            System.arraycopy(this.values, n, nArray, 0, this.size - n);
        }
        return nArray;
    }

    public void truncate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n < this.size) {
            this.size = n;
        }
    }

    public int[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    public IntStream stream() {
        return Arrays.stream(this.values, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

