/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.online.presenter;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MySqlDBManager {
    private static final Logger LOG = Logger.getLogger(MySqlDBManager.class);
    protected Connection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    protected String url;
    protected String user;
    protected String pass;
    protected boolean connected;

    public MySqlDBManager(String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.pass = string3;
        this.connected = false;
    }

    public MySqlDBManager(String string, String string2, String string3, String string4) {
        this(String.format("jdbc:mysql://%s%s", string, string2.trim().equals("") ? "" : ":" + string2), string3, string4);
    }

    public void connectDB() throws Exception {
        if (!this.connected) {
            Driver driver = (Driver)Class.forName("com.mysql.jdbc.Driver").newInstance();
            DriverManager.registerDriver(driver);
            String string = String.format("%s?user=%s&password=%s", this.url, this.user, this.pass);
            LOG.info((Object)("Trying to connect to: " + this.url));
            this.connection = DriverManager.getConnection(string);
            this.statement = this.connection.createStatement(1004, 1007);
            this.connected = true;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void closeConnection() {
        LOG.info((Object)"Closing connection.");
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.connected = false;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public ResultSet getResultSet(String string) throws SQLException {
        LOG.info((Object)("Executing query: " + string));
        this.resultSet = this.statement.executeQuery(string);
        return this.resultSet;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int updateDB(String string) throws SQLException {
        LOG.info((Object)("Executing query: " + string));
        this.statement.execute(string);
        return this.statement.getUpdateCount();
    }
}

