proc oo2b {val} {
    if {$val == "ON"} {
	return 1
    } else {
	return 0
    }
}
proc rtinparser {fileName list} {
    set tinfile [open ~/.tin/tinrc]

    while {![eof $tinfile]} {

	gets $tinfile line

	if [regexp {^\#} $line || regexp {^\n} $line] {
	    gets $tinfile line
	} 

	if [regexp {^auto_save=(.*)$} $line all file(autosave)] {
	    continue
	}
	
	if [regexp {^batch_save=(.*)$} $line all file(batchsave)] {
	    continue
	}
	
	if [regexp {^start_editor_offset=(.*)$} $line all file(seoffset)] {
	    continue
	}

	if [regexp {^default_editor_format=(.*)$} $line all file(deformat)] {
	    continue
	}

	if [regexp {^mark_saved_read=(.*)$} $line all file(msread)] {
	    continue
	}

	if [regexp {^kill_level=(.*)$} $line all file(killlevel)] {
	    continue
	}

	if [regexp {^inverse_okay=(.*)$} $line all file(inverseokay)] {
	    continue
	}

	if [regexp {^draw_arrow=(.*)$} $line all file(drawarrow)] {
	    continue
	}

	if [regexp {^print_header=(.*)$} $line all file(printheader)] {
	    continue
	}

	if [regexp {^pos_first_unread=(.*)$} $line all file(posfirstunread)] {
	    continue
	}

	if [regexp {^full_page_scroll=(.*)$} $line all file(fullpagescroll)] {
	    continue
	}

	if [regexp {^catchup_read_groups=(.*)$} $line all file(catchupreadgroups)] {
	    continue
	}

	if [regexp {^confirm_action=(.*)$} $line all file(confirmaction)] {
	    continue
	}

	if [regexp {^show_description=(.*)$} $line all file(showdescription)] {
	    continue
	}

	if [regexp {^show_author=(.*)$} $line all file(showauthor)] {
	    continue
	}

	if [regexp {^post_process_type=(.*)$} $line all file(postprocesstype)] {
	    continue
	}

	if [regexp {^thread_articles=(.*)$} $line all file(threadarticles)] {
	    continue
	}

	if [regexp {^unlink_article=(.*)$} $line all file(unlinkarticle)] {
	    continue
	}

	if [regexp {^show_only_unread_groups=(.*)$} $line all file(sounreadgroups)] {
	    continue
	}

	if [regexp {^show_only_unread=(.*)$} $line all file(showonlyunread)] {
	    continue
	}

	if [regexp {^sort_article_type=(.*)$} $line all file(sortarticletype)] {
	    continue
	}

	if [regexp {^default_savedir=(.*)$} $line all file(defaultsavedir)] {
	    continue
	}

	if [regexp {^default_maildir=(.*)$} $line all file(defaultmaildir)] {
	    continue
	}

	if [regexp {^default_printer=(.*)$} $line all file(defaultprinter)] {
	    continue
	}

	if [regexp {^default_sigfile=(.*)$} $line all file(defaultsigfile)] {
	    continue
	}

	if [regexp {^reread_active_file_secs=(.*)$} $line all file(rereadactfile)] {
	    continue
	}

	if [regexp {^quote_chars=(.*)$} $line all file(quotechars)] {
	    continue
	}

	if [regexp {^unread_art_mark=(.*)$} $line all file(unreadartmark)] {
	    continue
	}

	if [regexp {^hot_art_mark=(.*)$} $line all file(hotartmark)] {
	    continue
	}

	if [regexp {^return_art_mark=(.*)$} $line all file(returnartmark)] {
	    continue
	}

	if [regexp {^show_last_line_prev_page=(.*)$} $line all file(slastlinepage)] {
	    continue
	}

	if [regexp {^tab_after_X_selection=(.*)$} $line all file(tabaftrXselectn)] {
	    continue
	}

	if [regexp {^tab_goto_next_unread=(.*)$} $line all file(tabgotonextunread)] {
	    continue
	}

	if [regexp {^force_screen_redraw=(.*)$} $line all file(forcescreenredraw)] {
	    continue
	}

	if [regexp {^display_reading_prompt=(.*)$} $line all file(dispreadprompt)] {
	    continue
	}

	if [regexp {^save_to_mmdf_mailbox=(.*)$} $line all file(savetommdfmailbox)] {
	    continue
	}

	if [regexp {^use_builtin_inews=(.*)$} $line all file(usebuiltininews)] {
	    continue
	}

	if [regexp {^news_quote_format=(.*)$} $line all file(newsquoteformat)] {
	    continue
	}

	if [regexp {^mail_quote_format=(.*)$} $line all file(mailquoteformat)] {
	    continue
	}

	if [regexp {^auto_cc=(.*)$} $line all file(autocc)] {
	    continue
	}

	if [regexp {^slow_speed_terminal=(.*)$} $line all file(slowspeedterminal)] {
	    continue
	}

	if [regexp {^groupname_max_length=(.*)$} $line all file(groupnamemaxlength)] {
	    continue
	}

	if [regexp {^beginner_level=(.*)$} $line all file(beginnerlevel)] {
	    continue
	}

	if [regexp {^default_spooldir_alias=(.*)$} $line all file(defspooldiralias)] {
	    continue
	}

	if [regexp {^default_author_search=(.*)$} $line all file(defauthorsearch)] {
	    continue
	}

	if [regexp {^default_goto_group=(.*)$} $line all file(defgotogroup)] {
	    continue
	}

	if [regexp {^default_group_search=(.*)$} $line all file(defgroupsearch)] {
	    continue
	}

	if [regexp {^default_subject_search=(.*)$} $line all file(defsubjectsearch)] {
	    continue
	}

	if [regexp {^default_art_search=(.*)$} $line all file(defartsearch)] {
	    continue
	}

	if [regexp {^default_crosspost_group=(.*)$} $line all file(defcrosspost)] {
	    continue
	}

	if [regexp {^default_mail_address=(.*)$} $line all file(defmailaddress)] {
	    continue
	}

	if [regexp {^default_move_group=(.*)$} $line all file(defmovegroup)] {
	    continue
	}

	if [regexp {^default_pipe_command=(.*)$} $line all file(defpipecommand)] {
	    continue
	}

	if [regexp {^default_post_newsgroups=(.*)$} $line all file(defpostnews)] {
	    continue
	}

	if [regexp {^default_post_subject=(.*)$} $line all file(defpostsubject)] {
	    continue
	}

	if [regexp {^default_regex_pattern=(.*)$} $line all file(defregexpattern)] {
	    continue
	}

	if [regexp {^default_save_file=(.*)$} $line all file(defsavefile)] {
	    continue
	}

	if [regexp {^default_select_pattern=(.*)$} $line all file(defselectpattern)] {
	    continue
	}

	if [regexp {^default_shell_command=(.*)$} $line all file(defshellcommand)] {
	    continue
	}

	if [regexp {^use_keypad=(.*)$} $line all file(usekeypad)] {
	    continue
	}


	# some default values

	if [regexp {^motd_file_info=(.*)$} $line all file(motdfileinfo)] {
	    continue
	}

	if [regexp {^active_file_info=(.*)$} $line all file(activefileinfo)] {
	    continue
	}

    }
    close $tinfile
    set File [open $fileName w]
    
    puts $File "page internal"
    if {[info exist file(autosave)]} {
	puts $File "CHECKBOX autosavebox [oo2b $file(autosave)]" }
    if {[info exist file(batchsave)]} {
	puts $File "CheckBox batchsavebox [oo2b $file(batchsave)]" }
    if {[info exist file(seoffset)]} {
	puts $File "CheckBox edoffsetbox [oo2b $file(seoffset)]" }

    if {[info exist file(deformat)]} {
	puts $File "Entry edformat \"$file(deformat)\"" }

    if {[info exist file(usebuiltininews)]} {
	puts $File "CheckBox inews [oo2b $file(usebuiltininews)]" }
    if {[info exist file(slowspeedterminal)]} {
	puts $File "CheckBox slowspeed [oo2b $file(slowspeedterminal)]" }

    if {[info exist file(beginnerlevel)]} {
	puts $File "CheckBox beginner [oo2b $file(beginnerlevel)]" }
    if {[info exist file(usekeypad)]} {
	puts $File "CheckBox keypad [oo2b $file(usekeypad)]" }

    puts $File "page reading"
    if {[info exist file(msread)]} {
	puts $File "CheckBox markread [oo2b $file(msread)]" }

    if {[info exist file(killlevel)]} {
	switch $file(killlevel) {
	    0 {puts $File "Radio killlevel \"mark as read\"" }
	    1 {puts $File "Radio killlevel \"removed after kill\"" }
	}
    }

    if {[info exist file(inverseokay)]} {
	switch $file(inverseokay) {
	    0 {puts $File "Radio inversdrawarrow \"use inverse video\"" }
	    1 {puts $File "Radio inversdrawarrow \"draw arrow at selected article\"" }
	}
    }

    if {[info exist file(groupnamemaxlength)]} {
	puts $File "Entry maxname \"$file(groupnamemaxlength)\"" }

    if {[info exist file(printheader)]} {
	switch $file(printheader) {
	    0 {puts $File "Radio printheader \"Full mail header\"" }
	    1 {puts $File "Radio printheader \"Subject: & From: lines\"" }
	}
    }	

    if {[info exist file(posfirstunread)]} {
	switch $file(posfirstunread) {
	    0 {puts $File "Radio posunread \"first enread article\"" }
	    1 {puts $File "Radio posunread \"last article\"" }
	}
    }	

    if {[info exist file(fullpagescroll)]} {
	switch $file(fullpagescroll) {
	    0 {puts $File "Radio pagescroll \"full page scroll\"" }
	    1 {puts $File "Radio pagescroll \"half page scroll\"" }
	}
    }	

    if {[info exist file(catchupreadgroups)]} {
	puts $File  "CheckBox catchup [oo2b $file(catchupreadgroups)]" }
    if {[info exist file(confirmaction)]} {
	puts $File  "CheckBox confirm [oo2b $file(confirmaction)]" }
    if {[info exist file(showdescription)]} {
	puts $File  "CheckBox showdesc [oo2b $file(showdescription)]" }

    if {[info exist file(showauthor)]} {
	switch $file(showauthor) {
	    0 {puts $File "Radio showauthor \"none\"" }
	    1 {puts $File "Radio showauthor \"address\"" }
	    2 {puts $File "Radio showauthor \"full name\"" }
	    3 {puts $File "Radio showauthor \"both\"" }
	} 	
    }

    if {[info exist file(displayreadingprompt)]} {
	puts $File  "CheckBox prompt [oo2b $file(displayreadingprompt)]" }
    if {[info exist file(threadarticles)]} {
	puts $File  "CheckBox thread [oo2b $file(threadarticles)]" }
    if {[info exist file(tabgotonextunread)]} {
	puts $File  "CheckBox tabgoto [oo2b $file(tabgotonextunread)]" }
    if {[info exist file(tabaftrXselectn)]} {
	puts $File  "CheckBox tabx [oo2b $file(tabaftrXselectn)]" }

    puts $File "page posting"
    if {[info exist file(postprocesstype)]} {
	switch $file(postprocesstype) {
	    0 {puts $File "Menu postprocess \"none\"" }
	    1 {puts $File "Menu postprocess \"unshar\"" }
	    2 {puts $File "Menu postprocess \"uudecode\"" }
	    3 {puts $File "Menu postprocess \"uudecode & list zoo\"" }
	    4 {puts $File "Menu postprocess \"uudecode & extract zoo\"" }
	    5 {puts $File "Menu postprocess \"uudecode & list zip\"" }
	    6 {puts $File "Menu postprocess \"uudecode & extract zip\"" }
	    
	}
    }	

    if {[info exist file(unlinkarticle)]} {
	puts $File  "CheckBox unlink [oo2b $file(unlinkarticle)]" }
    if {[info exist file(sounreadgroups)]} {
	puts $File  "CheckBox unreadgroup [oo2b $file(sounreadgroups)]" }

    if {[info exist file(showonlyunread)]} {
	switch $file(showonlyunread) {
	    0 {puts $File "Radio unread \"show only new/unread articles\"" }
	    1 {puts $File "Radio unread \"show all articles\"" }
	}
    }	

    if {[info exist file(sortarticletype)]} {
	switch $file(sortarticletype) {
	    0 {puts $File "Menu sort \"nothing\"" }
	    1 {puts $File "Menu sort \"Subject, descending\"" }
	    2 {puts $File "Menu sort \"Subject, ascending\"" }
	    3 {puts $File "Menu sort \"From, descending\"" }
	    4 {puts $File "Menu sort \"From, ascending\"" }
	    5 {puts $File "Menu sort \"Date, descending\"" }
	    6 {puts $File "Menu sort \"Date, ascending\"" }
		    
	}
    }	

    if {[info exist file(newsquoteformat)]} {
	puts $File  "Entry newsquote \"$file(newsquoteformat)\"" }
    if {[info exist file(mailquoteformat)]} {
	puts $File  "Entry mailquote \"$file(mailquoteformat)\"" }

    if {[info exist file(autocc)]} {
	puts $File  "CheckBox autocc [oo2b $file(autocc)]" }

    puts $File "page directory"
    if {[info exist file(defaultsavedir)]} {
	puts $File  "Entry savedir \"$file(defaultsavedir)\"" }
    if {[info exist file(defaultmaildir)]} {
	puts $File  "Entry maildir \"$file(defaultmaildir)\"" }
    if {[info exist file(defaultprinter)]} {
	puts $File  "Entry printer \"$file(defaultprinter)\"" }
    if {[info exist file(defaultsigfile)]} {
	puts $File  "Entry signature \"$file(defaultsigfile)\"" }

    if {[info exist file(savetommdfmailbox)]} {
	puts $File  "CheckBox mmdf [oo2b $file(savetommdfmailbox)]" }

    puts $File "page special"
    if {[info exist file(rereadactfile)]} {
	puts $File  "Entry reread \"$file(rereadactfile)\"" }
    if {[info exist file(quotechars)]} {
	puts $File  "Entry quote \"$file(quotechars)\"" }
    if {[info exist file(unreadartmark)]} {
	puts $File  "Entry unreadmark \"$file(unreadartmark)\"" }
    if {[info exist file(hotartmark)]} {
	puts $File  "Entry hot \"$file(hotartmark)\"" }
    if {[info exist file(returnartmark)]} {
	puts $File  "Entry return \"$file(returnartmark)\"" }

    puts $File "page display"
    if {[info exist file(slastlinepage)]} {
	puts $File  "CheckBox showline [oo2b $file(slastlinepage)]" }
    if {[info exist file(forcescreenredraw)]} {
 	puts $File  "CheckBox redraw [oo2b $file(forcescreenredraw)]" }

    puts $File "page default"
    if {[info exist file(defspooldiralias)]} {
	puts $File  "Entry spooldir \"$file(defspooldiralias)\"" }
    if {[info exist file(defauthorsearch)]} {
	puts $File  "Entry authorsearch \"$file(defauthorsearch)\"" }
    if {[info exist file(defgotogroup)]} {
	puts $File  "Entry gotogroup \"$file(defgotogroup)\"" }
    if {[info exist file(defgroupsearch)]} {
	puts $File  "Entry groupsearch \"$file(defgroupsearch)\"" }
    if {[info exist file(defsubjectsearch)]} {
	puts $File  "Entry subjectsearch \"$file(defsubjectsearch)\"" }
    if {[info exist file(defartsearch)]} {
	puts $File  "Entry artsearch \"$file(defartsearch)\"" }
    if {[info exist file(defcrosspostgroup)]} {
	puts $File  "Entry crosspost \"$file(defcrosspostgroup)\"" }
    if {[info exist file(defmailaddress)]} {
	puts $File  "Entry mailaddr \"$file(defmailaddress)\"" }
    if {[info exist file(defmovegroup)]} {
	puts $File  "Entry movegroup \"$file(defmovegroup)\"" }
    if {[info exist file(defpipecommand)]} {
	puts $File  "Entry pipe \"$file(defpipecommand)\"" }
    if {[info exist file(defpostnewsgroups)]} {
	puts $File  "Entry postgroup \"$file(defpostnewsgroups)\"" }
    if {[info exist file(defpostsubject)]} {
	puts $File  "Entry postsubject \"$file(defpostsubject)\"" }
    if {[info exist file(defregexpattern)]} {
	puts $File  "Entry regexp \"$file(defregexpattern)\"" }
    if {[info exist file(defsavefile)]} {
	puts $File  "Entry savefile \"$file(defsavefile)\"" }
    if {[info exist file(defselectpattern)]} {
	puts $File  "Entry pattern \"$file(defselectpattern)\"" }
    if {[info exist file(defshellcommand)]} {
	puts $File  "Entry shell \"$file(defshellcommand)\"" }
    close $File
}





